/*
 * Decompiled with CFR 0.152.
 */
package uk.num.validators;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import uk.num.validators.ValidationResult;

public class NumUriPathValidator {
    public static final Pattern NUM_PATH_REGEX = Pattern.compile("^(/[^;,/\\\\?:@&=+$.#\\s]+)*/?$");
    public static final int MAX_PATH_PART_LENGTH = 63;

    private NumUriPathValidator() {
    }

    public static ValidationResult validateAcceptingNullAsValid(String path) {
        if (path == null) {
            return ValidationResult.VALID_NO_ERRORS;
        }
        return NumUriPathValidator.validate(path);
    }

    public static ValidationResult validate(String path) {
        ValidationResult result = new ValidationResult();
        try {
            if (path == null) {
                result.addMessage(ValidationResult.ErrorCode.NULL_UNACCEPTABLE, "path");
            } else {
                if (!path.startsWith("/")) {
                    result.addMessage(ValidationResult.ErrorCode.PATH_MUST_START_WITH_SLASH, path);
                }
                if (!path.equals("/")) {
                    String[] pathComponents = StringUtils.removeStart((String)path, (String)"/").split("/");
                    Arrays.stream(pathComponents).forEach(pathComponent -> {
                        if (pathComponent.getBytes().length == 0) {
                            result.addMessage(ValidationResult.ErrorCode.ZERO_LENGTH_PATH_COMPONENT, path);
                        }
                        if (pathComponent.getBytes().length > 63) {
                            result.addMessage(ValidationResult.ErrorCode.PATH_COMPONENT_TOO_LONG, (String)pathComponent);
                        }
                        if (pathComponent.contains(" ")) {
                            result.addMessage(ValidationResult.ErrorCode.PATH_COMPONENT_CONTAINS_SPACE, (String)pathComponent);
                        }
                        if (pathComponent.contains("\n")) {
                            result.addMessage(ValidationResult.ErrorCode.PATH_COMPONENT_CONTAINS_NEWLINE, (String)pathComponent);
                        }
                        if (pathComponent.contains("\r")) {
                            result.addMessage(ValidationResult.ErrorCode.PATH_COMPONENT_CONTAINS_CARRIAGE_RETURN, (String)pathComponent);
                        }
                        if (pathComponent.contains("\t")) {
                            result.addMessage(ValidationResult.ErrorCode.PATH_COMPONENT_CONTAINS_TAB, (String)pathComponent);
                        }
                        if (pathComponent.contains("\b")) {
                            result.addMessage(ValidationResult.ErrorCode.PATH_COMPONENT_CONTAINS_BACKSPACE, (String)pathComponent);
                        }
                        if (pathComponent.contains("\f")) {
                            result.addMessage(ValidationResult.ErrorCode.PATH_COMPONENT_CONTAINS_FORMFEED, (String)pathComponent);
                        }
                    });
                }
                if (!NUM_PATH_REGEX.matcher(path).matches()) {
                    result.addMessage(ValidationResult.ErrorCode.PATTERN_MISMATCH, path);
                }
            }
        }
        catch (Exception e) {
            result.addMessage(ValidationResult.ErrorCode.EXCEPTION_MESSAGE, e.getMessage());
        }
        return result;
    }
}

