/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.dns;

import java.util.Arrays;
import org.xbill.DNS.Record;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;
import uk.num.numlib.exc.RrSetNoHeadersException;

public interface DNSServices {
    public String rebuildTXTRecordContent(Record[] var1) throws RrSetNoHeadersException, RrSetHeaderFormatException, RrSetIncompleteException;

    public GetRecordResponse getRecordFromDnsNoCache(String var1, int var2) throws NumInvalidDNSQueryException, NumNoRecordAvailableException;

    public static final class GetRecordResponse {
        private final boolean isSigned;
        private final Record[] records;

        public GetRecordResponse(boolean isSigned, Record[] records) {
            this.isSigned = isSigned;
            this.records = records;
        }

        public boolean isSigned() {
            return this.isSigned;
        }

        public Record[] getRecords() {
            return this.records;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRecordResponse)) {
                return false;
            }
            GetRecordResponse other = (GetRecordResponse)o;
            if (this.isSigned() != other.isSigned()) {
                return false;
            }
            return Arrays.deepEquals(this.getRecords(), other.getRecords());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSigned() ? 79 : 97);
            result = result * 59 + Arrays.deepHashCode(this.getRecords());
            return result;
        }

        public String toString() {
            return "DNSServices.GetRecordResponse(isSigned=" + this.isSigned() + ", records=" + Arrays.deepToString(this.getRecords()) + ")";
        }
    }
}

