/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.Tuple2;
import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ConditionOrConditionGroupInterface;
import uk.modl.utils.IDSource;

public final class ConditionTest
implements Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<Tuple2<ConditionOrConditionGroupInterface, String>> conditions;

    public static ConditionTest of(Ancestry ancestry, Parent parent, Vector<Tuple2<ConditionOrConditionGroupInterface, String>> conditions) {
        ConditionTest child = ConditionTest.of(IDSource.nextId(), conditions);
        ancestry.add(parent, child);
        return child;
    }

    public ConditionTest with(Ancestry ancestry, Vector<Tuple2<ConditionOrConditionGroupInterface, String>> conditions) {
        ConditionTest child = ConditionTest.of(this.id, conditions);
        ancestry.replaceChild(this, child);
        return child;
    }

    private ConditionTest(long id, @NonNull Vector<Tuple2<ConditionOrConditionGroupInterface, String>> conditions) {
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        this.id = id;
        this.conditions = conditions;
    }

    public static ConditionTest of(long id, @NonNull Vector<Tuple2<ConditionOrConditionGroupInterface, String>> conditions) {
        return new ConditionTest(id, conditions);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<Tuple2<ConditionOrConditionGroupInterface, String>> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionTest)) {
            return false;
        }
        ConditionTest other = (ConditionTest)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "ConditionTest(conditions=" + this.getConditions() + ")";
    }
}

