/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.ancestry;

import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.ancestry.ScopedAncestrySearch;
import uk.modl.model.Array;
import uk.modl.model.Map;
import uk.modl.model.Pair;
import uk.modl.model.Primitive;
import uk.modl.transforms.TransformationContext;

public class Ancestry {
    private static final String LABEL_PREFIX = "\"[label=\"";
    private static final String LABEL_SUFFIX = "\"]\n\"";
    private final java.util.Map<Child, Parent> ancestors = new LinkedHashMap<Child, Parent>();
    private final ScopedAncestrySearch ancestrySearch = new ScopedAncestrySearch(this.ancestors);

    public void add(Parent parent, Child child) {
        if (child != null) {
            this.ancestors.put(child, parent);
        }
    }

    public Option<Pair> findByKey(Child child, String key) {
        return this.ancestrySearch.findByKey(child, key);
    }

    public void dump() {
        this.ancestors.entrySet().stream().map(e -> {
            Child child = (Child)e.getKey();
            Parent parent = (Parent)e.getValue();
            long childId = child.getId();
            String childHash = Integer.toHexString(System.identityHashCode(child));
            String childString = "" + childId + ":" + child.getClass().getSimpleName() + "\\n" + childHash;
            if (child instanceof Pair) {
                childString = childString + ":\\n" + ((Pair)child).getKey();
            }
            if (child instanceof Primitive) {
                childString = childString + ":\\n" + child.toString();
            }
            if (parent != null) {
                long parentId = parent.getId();
                String parentHash = Integer.toHexString(System.identityHashCode(parent));
                String parentString = "" + parentId + ":" + parent.getClass().getSimpleName() + "\\n" + parentHash;
                if (parent instanceof Pair) {
                    parentString = parentString + ":\\n" + ((Pair)parent).getKey();
                }
                if (parent instanceof Primitive) {
                    parentString = parentString + ":\\n" + parent.toString();
                }
                return "\"" + parentHash + LABEL_PREFIX + parentString + LABEL_SUFFIX + childHash + LABEL_PREFIX + childString + LABEL_SUFFIX + childHash + "\" -> \"" + parentHash + "\"";
            }
            return "missing[label=\"missing\"]\n\"" + childHash + LABEL_PREFIX + childString + LABEL_SUFFIX + childHash + "\" -> missing";
        }).forEach(System.out::println);
    }

    public Pair findReferencedPair(TransformationContext ctx, Child c, String key) {
        String hiddenKey = key.startsWith("_") ? key : "_" + key;
        String unhiddenKey = key.startsWith("_") ? key.substring(1) : key;
        return (Pair)ctx.getAncestry().findByKey(c, hiddenKey).orElse(() -> ctx.getAncestry().findByKey(c, unhiddenKey)).getOrElse((Object)null);
    }

    public void replaceChild(Child oldChild, Child newChild) {
        if (oldChild != null && newChild != null) {
            Parent parent = this.ancestors.remove(oldChild);
            List childrenOfOldChild = this.ancestors.entrySet().stream().filter(entry -> this.entryValueMatchesChild(oldChild, (Map.Entry<Child, Parent>)entry)).map(Map.Entry::getKey).collect(Collectors.toList());
            for (Child childOfOldChild : childrenOfOldChild) {
                this.ancestors.remove(childOfOldChild);
                this.ancestors.put(childOfOldChild, (Parent)((Object)newChild));
            }
            this.ancestors.put(newChild, parent);
        }
    }

    private boolean entryValueMatchesChild(Child oldChild, Map.Entry<Child, Parent> entry) {
        return entry.getValue() != null && entry.getValue().equals((Parent)((Object)oldChild));
    }

    private void prune(Parent parent) {
        List<Child> referencesToOldChild = this.ancestors.entrySet().stream().filter(entry -> entry.getValue() != null && ((Parent)entry.getValue()).equals(parent)).map(Map.Entry::getKey).collect(Collectors.toList());
        referencesToOldChild.forEach(this.ancestors::remove);
        referencesToOldChild.forEach(child -> this.prune((Parent)((Object)child)));
    }

    public void replaceSubTree(Child oldChild, Child newChild) {
        if (oldChild != null && newChild != null) {
            Parent parent = this.ancestors.remove(oldChild);
            this.prune((Parent)((Object)oldChild));
            this.ancestors.put(newChild, parent);
        }
    }

    public String pathTo(Vector<String> path, Parent parent) {
        if (parent == null) {
            return path.reverse().mkString((CharSequence)"/");
        }
        String element = parent instanceof Pair ? ((Pair)parent).getKey() : (parent instanceof Array ? "array" : (parent instanceof Map ? "map" : "object"));
        Vector newPath = path.append((Object)element);
        Parent grandparent = this.ancestors.get((Child)((Object)parent));
        return this.pathTo((Vector<String>)newPath, grandparent);
    }
}

