/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.Tuple2;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.interpreter.Interpreter;
import uk.modl.model.Modl;
import uk.modl.transforms.JacksonJsonNodeTransform;
import uk.modl.transforms.TransformationContext;

public class Interpret {
    private static final Logger log = LogManager.getLogger(Interpret.class);
    public static final int TIMEOUT_SECONDS = 10000;

    public static void main(String ... args) {
        if (args.length == 0) {
            log.info("Usage: java -cp ./build/libs/interpreter-<version>.jar <modl-file-name> [modl-file-name] ...");
        }
        int sum = Arrays.stream(args).mapToInt(filename -> {
            try {
                Path path = Paths.get(filename, new String[0]);
                String modlString = String.join((CharSequence)"\n", Files.readAllLines(path));
                Interpreter interpreter = new Interpreter();
                TransformationContext ctx = TransformationContext.baseCtx(new URL(path.toUri().toASCIIString()), 10000L);
                Tuple2<TransformationContext, Modl> interpreted = interpreter.apply(ctx, modlString);
                JsonNode json = new JacksonJsonNodeTransform(ctx).apply((Modl)interpreted._2);
                String result = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
                log.info(result);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                return 1;
            }
            return 0;
        }).sum();
        System.exit(sum);
    }
}

