/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

import io.vavr.Function2;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiFunction;
import uk.modl.model.Array;
import uk.modl.model.FalsePrimitive;
import uk.modl.model.Map;
import uk.modl.model.NullPrimitive;
import uk.modl.model.NumberPrimitive;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.StringPrimitive;
import uk.modl.model.TruePrimitive;
import uk.modl.transforms.StarClassTransform;
import uk.modl.transforms.TransformationContext;

public class SupertypeInference {
    private static final int MAX_RECURSION_DEPTH = 50;

    public static String inferType(TransformationContext ctx, StarClassTransform.ClassInstruction ci, PairValue pv) {
        String tc = SupertypeInference.topClass(ctx, ci, 0);
        if (tc == null) {
            if (SupertypeInference.hasAssignStatement(ctx, ci)) {
                tc = SupertypeInference.allAssignmentKeysAreClasses(ctx, ci) ? "arr" : "map";
            } else if (SupertypeInference.hasInheritedPairs(ctx, ci, 0)) {
                tc = "map";
            } else if (pv instanceof StringPrimitive) {
                tc = "str";
            } else if (pv instanceof NumberPrimitive) {
                tc = "num";
            } else if (pv instanceof TruePrimitive || pv instanceof FalsePrimitive) {
                tc = "bool";
            } else if (pv instanceof NullPrimitive) {
                tc = "null";
            } else if (pv instanceof Array) {
                tc = "arr";
            } else if (pv instanceof Map) {
                tc = "map";
            } else if (pv instanceof Pair) {
                tc = "map";
            } else {
                throw new NullPointerException("Unknown object type: " + pv.getClass());
            }
        }
        return tc;
    }

    private static boolean hasInheritedPairs(TransformationContext ctx, StarClassTransform.ClassInstruction ci, int depth) {
        if (depth > 50 || ci == null) {
            return false;
        }
        if (ci.getPairs().length() > 0) {
            return true;
        }
        return (Boolean)ctx.getClassByNameOrId(ci.getSuperclass()).map(sc -> SupertypeInference.hasInheritedPairs(ctx, sc, depth + 1)).getOrElse((Object)false);
    }

    private static boolean allAssignmentKeysAreClasses(TransformationContext ctx, StarClassTransform.ClassInstruction ci) {
        List<String> allInheritedAssignKeys = SupertypeInference.allInheritedAssignKeys(ctx, ci, 0);
        boolean allHaveAssigns = SupertypeInference.allAssignClassesHaveAssigns(ctx, allInheritedAssignKeys);
        boolean allAssignKeysAreClasses = allInheritedAssignKeys.map(ctx::getClassByNameOrId).count(Objects::isNull) == 0;
        return allHaveAssigns && allAssignKeysAreClasses;
    }

    private static boolean allAssignClassesHaveAssigns(TransformationContext ctx, List<String> allInheritedAssignKeys) {
        int expected = allInheritedAssignKeys.size();
        return expected == allInheritedAssignKeys.count(key -> {
            Option<StarClassTransform.ClassInstruction> maybeClass = ctx.getClassByNameOrId((String)key);
            return maybeClass.isDefined() && ((StarClassTransform.ClassInstruction)maybeClass.get()).getAssign().nonEmpty();
        });
    }

    private static boolean hasAssignStatement(TransformationContext ctx, StarClassTransform.ClassInstruction ci) {
        return SupertypeInference.allInheritedAssignKeys(ctx, ci, 0).nonEmpty();
    }

    private static List<String> allInheritedAssignKeys(TransformationContext ctx, StarClassTransform.ClassInstruction ci, int depth) {
        if (depth > 50 || ci == null) {
            return List.empty();
        }
        List assignKeys = (List)ci.getAssign().map(x -> ((Array)x).getArrayItems().map(Object::toString)).foldLeft((Object)List.empty(), (BiFunction)((Function2 & Serializable)List::appendAll));
        return assignKeys.appendAll((Iterable)ctx.getClassByNameOrId(ci.getSuperclass()).map(sc -> SupertypeInference.allInheritedAssignKeys(ctx, sc, depth + 1)).getOrElse((Object)List.empty()));
    }

    private static String topClass(TransformationContext ctx, StarClassTransform.ClassInstruction ci, int depth) {
        if (depth > 50 || ci == null) {
            return null;
        }
        return (String)ctx.getClassByNameOrId(ci.getSuperclass()).map(sc -> SupertypeInference.topClass(ctx, sc, depth + 1)).getOrElse((Object)ci.getSuperclass());
    }
}

