/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ConditionOrConditionGroupInterface;
import uk.modl.model.Operator;
import uk.modl.model.Primitive;
import uk.modl.model.ValueItem;
import uk.modl.utils.IDSource;

public final class Condition
implements ConditionOrConditionGroupInterface,
Parent,
Child {
    private final long id;
    private final Primitive lhs;
    private final Operator op;
    @NonNull
    private final Vector<ValueItem> values;
    private final boolean shouldNegate;

    public static Condition of(Ancestry ancestry, Parent parent, Primitive lhs, Operator op, Vector<ValueItem> values, boolean shouldNegate) {
        Condition child = Condition.of(IDSource.nextId(), lhs, op, values, shouldNegate);
        ancestry.add(parent, child);
        return child;
    }

    public Condition with(Ancestry ancestry, Primitive lhs, Operator op, Vector<ValueItem> values, boolean shouldNegate) {
        Condition child = Condition.of(this.id, lhs, op, values, shouldNegate);
        ancestry.replaceChild(this, child);
        return child;
    }

    private Condition(long id, Primitive lhs, Operator op, @NonNull Vector<ValueItem> values, boolean shouldNegate) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.id = id;
        this.lhs = lhs;
        this.op = op;
        this.values = values;
        this.shouldNegate = shouldNegate;
    }

    public static Condition of(long id, Primitive lhs, Operator op, @NonNull Vector<ValueItem> values, boolean shouldNegate) {
        return new Condition(id, lhs, op, values, shouldNegate);
    }

    @Override
    public long getId() {
        return this.id;
    }

    public Primitive getLhs() {
        return this.lhs;
    }

    public Operator getOp() {
        return this.op;
    }

    @NonNull
    public Vector<ValueItem> getValues() {
        return this.values;
    }

    public boolean isShouldNegate() {
        return this.shouldNegate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "Condition(lhs=" + this.getLhs() + ", op=" + this.getOp() + ", values=" + this.getValues() + ", shouldNegate=" + this.isShouldNegate() + ")";
    }
}

