/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ArrayItem;
import uk.modl.model.MapItem;
import uk.modl.model.PairValue;
import uk.modl.model.Structure;
import uk.modl.model.ValueItem;
import uk.modl.utils.IDSource;
import uk.modl.utils.Util;

public final class Pair
implements Structure,
MapItem,
ValueItem,
ArrayItem,
Parent,
Child {
    private final long id;
    @NonNull
    private final String key;
    @NonNull
    private final PairValue value;

    public static Pair of(Ancestry ancestry, Parent parent, String key, PairValue value) {
        Util.validatePairKey(key);
        Pair child = Pair.of(IDSource.nextId(), key, value);
        ancestry.add(parent, child);
        return child;
    }

    @Override
    public Number numericValue() {
        return this.value.numericValue();
    }

    public Pair with(Ancestry ancestry, PairValue v) {
        Pair child = Pair.of(this.id, this.key, v);
        ancestry.replaceChild(this, child);
        return child;
    }

    public Pair with(Ancestry ancestry, String key, PairValue value) {
        Util.validatePairKey(key);
        Pair child = Pair.of(this.id, key, value);
        ancestry.replaceChild(this, child);
        return child;
    }

    private Pair(long id, @NonNull String key, @NonNull PairValue value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.id = id;
        this.key = key;
        this.value = value;
    }

    public static Pair of(long id, @NonNull String key, @NonNull PairValue value) {
        return new Pair(id, key, value);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public PairValue getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "Pair(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }
}

