/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import uk.modl.interpreter.Interpreter;
import uk.modl.interpreter.ModlClassLoader;
import uk.modl.interpreter.VariableMethods;
import uk.modl.modlObject.ModlObject;

class VariableMethodLoader {
    VariableMethodLoader() {
    }

    static void loadVariableMethod(List<MethodDescriptor> methodList, ModlObject.Structure structure, Interpreter interpreter) {
        MethodDescriptor desc = new MethodDescriptor();
        String methodName = ModlClassLoader.getPairValueFor(structure, "*id", interpreter);
        if (methodName == null) {
            methodName = ModlClassLoader.getPairValueFor(structure, "*i", interpreter);
        }
        desc.id = methodName;
        String description = ModlClassLoader.getPairValueFor(structure, "*name", interpreter);
        if (description == null) {
            description = ModlClassLoader.getPairValueFor(structure, "*n", interpreter);
        }
        desc.name = description;
        String methodString = ModlClassLoader.getPairValueFor(structure, "*transform", interpreter);
        if (methodString == null) {
            methodString = ModlClassLoader.getPairValueFor(structure, "*t", interpreter);
        }
        if (methodString != null) {
            methodString = methodString.replace("`", "");
        }
        desc.transform = methodString;
        VariableMethodLoader.createVariableMethod(methodName, methodString);
        for (MethodDescriptor d : methodList) {
            if (!Objects.equals(d.id, desc.id) && !Objects.equals(d.id, desc.name) && !Objects.equals(d.name, desc.name) && !Objects.equals(d.name, desc.id)) continue;
            throw new RuntimeException("Interpreter Error: Duplicate method id or name: " + desc.name);
        }
        methodList.add(desc);
    }

    private static void createVariableMethod(String methodName, String methodString) {
        final List<Map<String, String>> methodsAndParams = VariableMethodLoader.getMethodsAndParams(methodString);
        VariableMethods.TaskRunner newTask = new VariableMethods.TaskRunner(){

            @Override
            public void run() {
                String intermediateResult = this.parameter;
                for (Map methodAndParam : methodsAndParams) {
                    String method;
                    String params = (String)methodAndParam.get(method = (String)methodAndParam.keySet().toArray()[0]);
                    if (params == null || params.length() == 0) {
                        intermediateResult = Interpreter.variableMethods.transform(method, intermediateResult);
                        continue;
                    }
                    intermediateResult = Interpreter.variableMethods.transform(method, intermediateResult + "," + params);
                }
                this.result = intermediateResult;
            }
        };
        Interpreter.variableMethods.addMethod(methodName, newTask);
    }

    private static List<Map<String, String>> getMethodsAndParams(String methodString) {
        LinkedList<Map<String, String>> methodsAndParams = new LinkedList<Map<String, String>>();
        while (methodString.indexOf("(") > 0 || methodString.length() > 0) {
            int bracketIndex = methodString.indexOf("(");
            int dotIndex = methodString.indexOf(".");
            int endOfStringIndex = methodString.length();
            int actualIndex = bracketIndex;
            if (actualIndex < 0) {
                actualIndex = dotIndex;
            } else if (dotIndex > 0) {
                actualIndex = Math.min(dotIndex, bracketIndex);
            }
            if (actualIndex < 0) {
                actualIndex = endOfStringIndex;
            }
            String intermediateMethodName = methodString.substring(0, actualIndex);
            String params = null;
            int endIndex = endOfStringIndex;
            if (actualIndex == bracketIndex) {
                int closeBracketIndex = methodString.indexOf(")");
                params = methodString.substring(bracketIndex + 1, closeBracketIndex);
                endIndex = closeBracketIndex + 1;
                if (endIndex < methodString.length()) {
                    ++endIndex;
                }
            } else if (actualIndex == dotIndex) {
                endIndex = actualIndex + 1;
            }
            HashMap<String, String> methodAndParam = new HashMap<String, String>();
            methodAndParam.put(intermediateMethodName, params);
            methodsAndParams.add(methodAndParam);
            methodString = methodString.substring(endIndex);
        }
        return methodsAndParams;
    }

    public static class MethodDescriptor {
        public String name;
        String id;
        String transform;
    }
}

