/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.RawModlObject;

public class ModlClassLoader {
    public static void loadClass(ModlObject.Structure structure, Map<String, Map<String, Object>> klasses) {
        if (structure instanceof ModlObject.Pair) {
            ModlObject.Pair pair = (ModlObject.Pair)structure;
            if (pair == null || !pair.getKey().string.equals("*class") && !pair.getKey().string.equals("*c")) {
                throw new RuntimeException("Expecting '*class' in ModlClassLoader");
            }
            ModlClassLoader.loadClassStructure(structure, klasses);
        }
    }

    private static void loadClassStructure(ModlObject.Structure structure, Map<String, Map<String, Object>> klasses) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        String id = ModlClassLoader.getPairValueFor(structure, "*id");
        if (id == null) {
            id = ModlClassLoader.getPairValueFor(structure, "*i");
        }
        if (id == null) {
            throw new RuntimeException("Can't find *id in *class");
        }
        klasses.put(id, values);
        String superclass = ModlClassLoader.getPairValueFor(structure, "*superclass");
        if (superclass == null) {
            superclass = ModlClassLoader.getPairValueFor(structure, "*s");
        }
        values.put("*superclass", superclass);
        String name = ModlClassLoader.getPairValueFor(structure, "*name");
        if (name == null) {
            name = ModlClassLoader.getPairValueFor(structure, "*n");
        }
        if (name == null) {
            name = id;
        }
        values.put("*name", name);
        Map<String, Object> superKlass = klasses.get(superclass);
        if (superclass != null && superclass.toUpperCase().equals(superclass)) {
            throw new RuntimeException("Can't derive from " + superclass + ", as it in upper case and therefore fixed");
        }
        if (superKlass != null) {
            for (Map.Entry entry : superKlass.entrySet()) {
                values.put((String)entry.getKey(), entry.getValue());
            }
        }
        for (ModlObject.Pair pair : ((ModlObject.Map)((ModlObject.Pair)structure).getModlValue()).getPairs()) {
            if (pair.getKey().string.equals("*id") || pair.getKey().string.equals("*i") || pair.getKey().string.equals("*superclass") || pair.getKey().string.equals("*s")) continue;
            if (pair.getKey().string.equals("*assign") || pair.getKey().string.equals("*a")) {
                if (!(pair.getModlValue() instanceof ModlObject.Array)) continue;
                ModlClassLoader.loadParams(values, (ModlObject.Array)pair.getModlValue());
                continue;
            }
            if (pair.getKey().string.equals("*n")) {
                values.put("*name", pair.getModlValue());
                continue;
            }
            values.put(pair.getKey().string, pair.getModlValue());
        }
    }

    private static void loadParams(HashMap<String, Object> values, ModlObject.Array array) {
        for (ModlValue v : array.getValues()) {
            ModlObject.Array a = (ModlObject.Array)v;
            String key = "*params" + a.getValues().size();
            LinkedList<ModlValue> vs = new LinkedList<ModlValue>();
            for (ModlValue ai : a.getValues()) {
                vs.add(ai);
            }
            values.put(key, vs);
        }
    }

    public static String getPairValueFor(ModlObject.Structure structure, String pairValue) {
        for (ModlObject.Pair mapItem : ((ModlObject.Map)((ModlObject.Pair)structure).getModlValue()).getPairs()) {
            if (!mapItem.getKey().string.equals(pairValue)) continue;
            return ((ModlObject.String)mapItem.getModlValue()).string;
        }
        return null;
    }

    public static void loadModlKlassO(RawModlObject rawModlObject, Map<String, Map<String, Object>> klasses) {
        LinkedHashMap<String, ModlObject.String> o = new LinkedHashMap<String, ModlObject.String>();
        RawModlObject rawModlObject2 = rawModlObject;
        rawModlObject2.getClass();
        ModlObject.String superclass = new ModlObject.String(rawModlObject2, "map");
        o.put("*superclass", superclass);
        RawModlObject rawModlObject3 = rawModlObject;
        rawModlObject3.getClass();
        ModlObject.String name = new ModlObject.String(rawModlObject3, "o");
        o.put("*name", name);
        RawModlObject rawModlObject4 = rawModlObject;
        rawModlObject4.getClass();
        ModlObject.String output = new ModlObject.String(rawModlObject4, "map");
        o.put("*output", output);
        klasses.put("o", o);
    }
}

