/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.ModlParsed;
import uk.modl.parser.Parser;
import uk.modl.parser.RawModlObject;

public class ModlObjectCreator {
    public static int MODL_VERSION = 1;

    public static RawModlObject processModlParsed(String input) throws IOException {
        ModlParsed modlParsed = Parser.parse(input);
        return ModlObjectCreator.processModlParsed(modlParsed);
    }

    private static RawModlObject processModlParsed(ModlParsed modlParsed) {
        RawModlObject rawModlObject = new RawModlObject();
        for (ModlParsed.Structure parsedStructure : modlParsed.getStructures()) {
            List<ModlObject.Structure> structures = ModlObjectCreator.processModlParsed(parsedStructure);
            if (structures == null) continue;
            for (ModlObject.Structure structure : structures) {
                if (structure == null) continue;
                rawModlObject.addStructure(structure);
            }
        }
        return rawModlObject;
    }

    private static List<ModlObject.Structure> processModlParsed(ModlParsed.Structure parsedStructure) {
        if (parsedStructure == null) {
            return null;
        }
        List<ModlObject.Structure> structures = new LinkedList<ModlObject.Structure>();
        ModlObject.Structure structure = ModlObjectCreator.processModlParsed(parsedStructure.getMap());
        if (structure != null) {
            structures.add(structure);
            return structures;
        }
        structure = ModlObjectCreator.processModlParsed(parsedStructure.getArray());
        if (structure != null) {
            structures.add(structure);
            return structures;
        }
        structures = ModlObjectCreator.processModlParsed(parsedStructure.getPair());
        if (structures != null) {
            return structures;
        }
        structure = ModlObjectCreator.processModlParsed(parsedStructure.getTopLevelConditional());
        structures = new LinkedList();
        structures.add(structure);
        return structures;
    }

    private static ModlObject.Map processModlParsed(ModlParsed.Map parsedMap) {
        if (parsedMap == null) {
            return null;
        }
        ModlObject.Map map = new ModlObject.Map();
        if (parsedMap.getMapItems() != null) {
            for (ModlParsed.MapItem mapItemParsed : parsedMap.getMapItems()) {
                ModlObject.Pair pair = ModlObjectCreator.processModlParsed(mapItemParsed);
                if (pair == null) continue;
                map.addPair(pair);
            }
        }
        return map;
    }

    private static ModlObject.Pair processModlParsed(ModlParsed.MapItem parsedMapItem) {
        if (parsedMapItem == null) {
            return null;
        }
        RawModlObject.MapConditional pair = ModlObjectCreator.processModlParsed(parsedMapItem.getMapConditional());
        if (pair != null) {
            return pair;
        }
        List<ModlObject.Structure> structures = ModlObjectCreator.processModlParsed(parsedMapItem.getPair());
        if (structures.size() > 0) {
            return (ModlObject.Pair)structures.get(0);
        }
        return null;
    }

    private static ModlValue processModlParsed(ModlParsed.Value parsedValue) {
        if (parsedValue == null) {
            return null;
        }
        List<ModlObject.Structure> pairs = ModlObjectCreator.processModlParsed(parsedValue.getPair());
        if (pairs != null && pairs.size() > 0) {
            return pairs.get(0);
        }
        ModlValue value = ModlObjectCreator.processModlParsed(parsedValue.getMap());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getArray());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getNbArray());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getPrimitive());
        return value;
    }

    private static ModlValue processModlParsed(ModlParsed.Primitive parsedValue) {
        if (parsedValue == null) {
            return null;
        }
        ModlValue value = ModlObjectCreator.processModlParsed(parsedValue.getQuoted());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getNumber());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getTrueVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getFalseVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getNullVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getString());
        if (value != null) {
            return value;
        }
        return value;
    }

    private static ModlValue processModlParsed(ModlParsed.ArrayValueItem parsedValue) {
        if (parsedValue == null) {
            return null;
        }
        List<ModlObject.Structure> pairs = ModlObjectCreator.processModlParsed(parsedValue.getPair());
        if (pairs != null && pairs.size() > 0) {
            return pairs.get(0);
        }
        ModlValue value = ModlObjectCreator.processModlParsed(parsedValue.getMap());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getArray());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(parsedValue.getPrimitive());
        return value;
    }

    private static RawModlObject.ConditionTest processModlParsed(ModlParsed.ConditionTest conditionTestParsed) {
        if (conditionTestParsed == null) {
            return null;
        }
        RawModlObject.ConditionTest conditionTest = new RawModlObject.ConditionTest();
        for (ImmutablePair<ModlParsed.SubCondition, ImmutablePair<String, Boolean>> subConditionPair : conditionTestParsed.subConditionList) {
            ModlParsed.SubCondition subCondition = (ModlParsed.SubCondition)subConditionPair.getLeft();
            ImmutablePair operatorPair = (ImmutablePair)subConditionPair.getRight();
            String operator = (String)operatorPair.getLeft();
            Boolean shouldNegate = (Boolean)operatorPair.getRight();
            if (subCondition instanceof ModlParsed.ConditionGroup) {
                RawModlObject.ConditionGroup conditionGroup = ModlObjectCreator.processModlParsed((ModlParsed.ConditionGroup)subCondition);
                conditionTest.addSubCondition(operator, shouldNegate, conditionGroup);
                continue;
            }
            if (!(subCondition instanceof ModlParsed.Condition)) continue;
            RawModlObject.Condition condition = ModlObjectCreator.processModlParsed((ModlParsed.Condition)subCondition);
            conditionTest.addSubCondition(operator, shouldNegate, condition);
        }
        return conditionTest;
    }

    private static RawModlObject.Condition processModlParsed(ModlParsed.Condition conditionParsed) {
        if (conditionParsed == null) {
            return null;
        }
        String key = conditionParsed.key;
        String operator = conditionParsed.operator;
        LinkedList<ModlValue> values = new LinkedList<ModlValue>();
        for (ModlParsed.Value valueParsed : conditionParsed.values) {
            ModlValue value = ModlObjectCreator.processModlParsed(valueParsed);
            values.add(value);
        }
        return new RawModlObject.Condition(key, operator, values);
    }

    private static RawModlObject.ConditionGroup processModlParsed(ModlParsed.ConditionGroup conditionGroupParsed) {
        if (conditionGroupParsed == null) {
            return null;
        }
        RawModlObject.ConditionGroup conditionGroup = new RawModlObject.ConditionGroup();
        for (ImmutablePair<ModlParsed.ConditionTest, String> conditionTestPair : conditionGroupParsed.conditionsTestList) {
            ModlParsed.ConditionTest conditionTestParsed = (ModlParsed.ConditionTest)conditionTestPair.getLeft();
            String operator = (String)conditionTestPair.getRight();
            RawModlObject.ConditionTest conditionTest = ModlObjectCreator.processModlParsed(conditionTestParsed);
            conditionGroup.addConditionTest(conditionTest, operator);
        }
        return conditionGroup;
    }

    private static List<ModlObject.Structure> processModlParsed(ModlParsed.Pair pairParsed) {
        ModlObject.Array array;
        if (pairParsed == null) {
            return null;
        }
        ModlObject.Pair pair = new ModlObject.Pair();
        pair.setKey(new ModlObject.String(pairParsed.getKey()));
        if (pairParsed.getKey() != null && (pairParsed.getKey().toLowerCase().equals("*l") || pairParsed.getKey().toLowerCase().equals("*load"))) {
            return ModlObjectCreator.processImportStatement(pairParsed);
        }
        ModlObject.Map map = ModlObjectCreator.processModlParsed(pairParsed.getMap());
        if (map != null) {
            pair.addModlValue(map);
        }
        if ((array = ModlObjectCreator.processModlParsed(pairParsed.getArray())) != null) {
            pair.addModlValue(array);
        }
        if (pairParsed.getValueItem() != null) {
            pair.addModlValue(ModlObjectCreator.processModlParsed(pairParsed.getValueItem(), pair));
        }
        LinkedList<ModlObject.Structure> pairs = new LinkedList<ModlObject.Structure>();
        pairs.add(pair);
        return pairs;
    }

    private static List<ModlObject.Structure> processImportStatement(ModlParsed.Pair pairParsed) {
        LinkedList<ModlObject.Structure> structures = new LinkedList<ModlObject.Structure>();
        ModlObject.Array array = ModlObjectCreator.processModlParsed(pairParsed.getArray());
        if (array == null && pairParsed.getValueItem() != null && pairParsed.getValueItem().getValue() != null) {
            array = ModlObjectCreator.processModlParsed(pairParsed.getValueItem().getValue().getNbArray());
        }
        if (array != null) {
            int count = 0;
            boolean isFinal = false;
            for (ModlValue v : array.getValues()) {
                if (count++ == array.getValues().size()) {
                    isFinal = true;
                }
                ModlObject.Pair pair = new ModlObject.Pair();
                String key = pairParsed.getKey();
                if (!isFinal) {
                    key = key.toLowerCase();
                }
                pair.setKey(new ModlObject.String(key));
                pair.addModlValue(v);
                structures.add(pair);
            }
        } else if (pairParsed.getValueItem() != null) {
            ModlObject.Pair pair = new ModlObject.Pair();
            pair.setKey(new ModlObject.String(pairParsed.getKey()));
            ModlParsed.ValueItem valueParsed = pairParsed.getValueItem();
            ModlValue v = ModlObjectCreator.processModlParsed(valueParsed, pair);
            pair.addModlValue(v);
            structures.add(pair);
        }
        return structures;
    }

    private static ModlObject.Array processModlParsed(ModlParsed.Array arrayParsed) {
        if (arrayParsed == null) {
            return null;
        }
        ModlObject.Array array = new ModlObject.Array();
        if (arrayParsed.getAbstractArrayItems() != null) {
            for (ModlParsed.AbstractArrayItem arrayItemParsed : arrayParsed.getAbstractArrayItems()) {
                if (arrayItemParsed instanceof ModlParsed.ArrayItem) {
                    ModlValue value = ModlObjectCreator.processModlParsed((ModlParsed.ArrayItem)arrayItemParsed);
                    if (value == null) continue;
                    array.addValue(value);
                    continue;
                }
                if (!(arrayItemParsed instanceof ModlParsed.NbArray)) continue;
                ModlObject.Array nbArray = new ModlObject.Array();
                for (ModlParsed.ArrayItem ai : ((ModlParsed.NbArray)arrayItemParsed).getArrayItems()) {
                    ModlValue value = ModlObjectCreator.processModlParsed(ai);
                    if (value == null) continue;
                    nbArray.addValue(value);
                }
                array.addValue(nbArray);
            }
        }
        return array;
    }

    private static ModlObject.Array processModlParsed(ModlParsed.NbArray nbArray) {
        if (nbArray == null || nbArray.getArrayItems().size() == 0) {
            return null;
        }
        ModlObject.Array array = new ModlObject.Array();
        for (ModlParsed.ArrayItem arrayItem : nbArray.getArrayItems()) {
            ModlValue value = ModlObjectCreator.processModlParsed(arrayItem);
            array.addValue(value);
        }
        return array;
    }

    private static ModlValue processModlParsed(ModlParsed.ArrayItem arrayItemParsed) {
        if (arrayItemParsed == null) {
            return null;
        }
        ModlValue value = null;
        if (arrayItemParsed.getArrayConditional() != null) {
            value = ModlObjectCreator.processModlParsed(arrayItemParsed.getArrayConditional());
        }
        if (arrayItemParsed.getArrayValueItem() != null) {
            value = ModlObjectCreator.processModlParsed(arrayItemParsed.getArrayValueItem());
        }
        return value;
    }

    private static ModlValue processModlParsed(ModlParsed.ValueItem valueItemParsed, ModlObject.Pair parentPair) {
        if (valueItemParsed == null) {
            return null;
        }
        ModlValue value = null;
        if (valueItemParsed.getValueConditional() != null) {
            value = ModlObjectCreator.processModlParsed(valueItemParsed.getValueConditional(), parentPair);
        }
        if (valueItemParsed.getValue() != null) {
            value = ModlObjectCreator.processModlParsed(valueItemParsed.getValue());
        }
        return value;
    }

    private static ModlObject.False processModlParsed(ModlParsed.False falseVal) {
        if (falseVal != null) {
            return new ModlObject.False();
        }
        return null;
    }

    private static ModlObject.Null processModlParsed(ModlParsed.Null val) {
        if (val != null) {
            return new ModlObject.Null();
        }
        return null;
    }

    private static ModlObject.True processModlParsed(ModlParsed.True trueVal) {
        if (trueVal != null) {
            return new ModlObject.True();
        }
        return null;
    }

    private static ModlObject.Number processModlParsed(ModlParsed.Number number) {
        if (number != null) {
            return new ModlObject.Number(number.string);
        }
        return null;
    }

    private static ModlObject.String processModlParsed(ModlParsed.String string) {
        if (string != null) {
            return new ModlObject.String(string.string);
        }
        return null;
    }

    private static ModlObject.String processModlParsed(ModlParsed.Quoted quoted) {
        if (quoted != null) {
            String s = quoted.string;
            if (s.startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1);
            }
            return new ModlObject.String(s);
        }
        return null;
    }

    private static RawModlObject.ValueConditional processModlParsed(ModlParsed.ValueConditional conditionalParsed, ModlObject.Pair parentPair) {
        if (conditionalParsed == null) {
            return null;
        }
        RawModlObject.ValueConditional conditional = new RawModlObject.ValueConditional();
        for (Map.Entry<ModlParsed.ConditionTest, ModlParsed.ValueConditionalReturn> conditionalParsedEntry : conditionalParsed.getValueConditionalReturns().entrySet()) {
            conditional.addConditional(ModlObjectCreator.processModlParsed(conditionalParsedEntry.getKey()), ModlObjectCreator.processModlParsed(conditionalParsedEntry.getValue(), parentPair));
        }
        return conditional;
    }

    private static RawModlObject.ValueConditionalReturn processModlParsed(ModlParsed.ValueConditionalReturn conditionalReturnParsed, ModlObject.Pair parentPair) {
        if (conditionalReturnParsed == null) {
            return null;
        }
        RawModlObject.ValueConditionalReturn conditionalReturn = new RawModlObject.ValueConditionalReturn();
        if (conditionalReturnParsed.getValueItems() != null) {
            for (ModlParsed.ValueItem valueParsed : conditionalReturnParsed.getValueItems()) {
                ModlValue value = ModlObjectCreator.processModlParsed(valueParsed, parentPair);
                conditionalReturn.addValue(value);
            }
        }
        return conditionalReturn;
    }

    private static ModlValue processModlParsed(ModlParsed.ArrayConditional conditionalParsed) {
        if (conditionalParsed == null) {
            return null;
        }
        RawModlObject.ArrayConditional conditional = new RawModlObject.ArrayConditional();
        if (conditionalParsed.getArrayConditionalReturns() != null) {
            for (Map.Entry<ModlParsed.ConditionTest, ModlParsed.ArrayConditionalReturn> conditionalParsedEntry : conditionalParsed.getArrayConditionalReturns().entrySet()) {
                conditional.addConditional(ModlObjectCreator.processModlParsed(conditionalParsedEntry.getKey()), ModlObjectCreator.processModlParsed(conditionalParsedEntry.getValue()));
            }
        }
        return conditional;
    }

    private static RawModlObject.ArrayConditionalReturn processModlParsed(ModlParsed.ArrayConditionalReturn conditionalReturnParsed) {
        if (conditionalReturnParsed == null) {
            return null;
        }
        RawModlObject.ArrayConditionalReturn conditionalReturn = new RawModlObject.ArrayConditionalReturn();
        if (conditionalReturnParsed.getArrayItems() != null) {
            for (ModlParsed.ArrayItem valueParsed : conditionalReturnParsed.getArrayItems()) {
                ModlValue value = ModlObjectCreator.processModlParsed(valueParsed);
                conditionalReturn.addValue(value);
            }
        }
        return conditionalReturn;
    }

    private static RawModlObject.MapConditional processModlParsed(ModlParsed.MapConditional conditionalParsed) {
        if (conditionalParsed == null) {
            return null;
        }
        RawModlObject.MapConditional conditional = new RawModlObject.MapConditional();
        for (Map.Entry<ModlParsed.ConditionTest, ModlParsed.MapConditionalReturn> conditionalParsedEntry : conditionalParsed.getMapConditionals().entrySet()) {
            conditional.addConditional(ModlObjectCreator.processModlParsed(conditionalParsedEntry.getKey()), ModlObjectCreator.processModlParsed(conditionalParsedEntry.getValue()));
        }
        return conditional;
    }

    private static ModlObject.Map processModlParsed(ModlParsed.MapConditionalReturn conditionalReturnParsed) {
        if (conditionalReturnParsed == null) {
            return null;
        }
        ModlObject.Map map = new ModlObject.Map();
        if (conditionalReturnParsed.getMapItems() != null) {
            for (ModlParsed.MapItem valueParsed : conditionalReturnParsed.getMapItems()) {
                ModlObject.Pair p = ModlObjectCreator.processModlParsed(valueParsed);
                map.addPair(p);
            }
        }
        return map;
    }

    private static RawModlObject.TopLevelConditional processModlParsed(ModlParsed.TopLevelConditional conditionalParsed) {
        if (conditionalParsed == null) {
            return null;
        }
        RawModlObject.TopLevelConditional conditional = new RawModlObject.TopLevelConditional();
        for (Map.Entry<ModlParsed.ConditionTest, ModlParsed.TopLevelConditionalReturn> conditionalParsedEntry : conditionalParsed.getTopLevelConditionalReturns().entrySet()) {
            conditional.addConditional(ModlObjectCreator.processModlParsed(conditionalParsedEntry.getKey()), ModlObjectCreator.processModlParsed(conditionalParsedEntry.getValue()));
        }
        return conditional;
    }

    private static RawModlObject.TopLevelConditionalReturn processModlParsed(ModlParsed.TopLevelConditionalReturn conditionalReturnParsed) {
        if (conditionalReturnParsed == null) {
            return null;
        }
        RawModlObject.TopLevelConditionalReturn conditionalReturn = new RawModlObject.TopLevelConditionalReturn();
        if (conditionalReturnParsed.getStructures() != null) {
            for (ModlParsed.Structure valueParsed : conditionalReturnParsed.getStructures()) {
                List<ModlObject.Structure> structures = ModlObjectCreator.processModlParsed(valueParsed);
                conditionalReturn.addStructure(structures.get(0));
            }
        }
        return conditionalReturn;
    }
}

