/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import uk.modl.interpreter.ModlClassLoader;
import uk.modl.modlObject.ModlObject;

public class VariableMethodLoader {
    public static void loadVariableMethod(ModlObject.Structure structure, Map<String, Function<String, String>> variableMethods) {
        String methodString;
        String description;
        String methodName = ModlClassLoader.getPairValueFor(structure, "*id");
        if (methodName == null) {
            methodName = ModlClassLoader.getPairValueFor(structure, "*i");
        }
        if ((description = ModlClassLoader.getPairValueFor(structure, "*name")) == null) {
            description = ModlClassLoader.getPairValueFor(structure, "*n");
        }
        if (description == null) {
            description = methodName;
        }
        if ((methodString = ModlClassLoader.getPairValueFor(structure, "*transform")) == null) {
            methodString = ModlClassLoader.getPairValueFor(structure, "*t");
        }
        methodString = methodString.replace("`", "");
        VariableMethodLoader.createVariableMethod(methodName, methodString, variableMethods);
    }

    private static void createVariableMethod(String methodName, String methodString, Map<String, Function<String, String>> variableMethods) {
        List<Map<String, String>> methodsAndParams = VariableMethodLoader.getMethodsAndParams(methodString);
        Function<String, String> function = VariableMethodLoader.createNewFunction(variableMethods, methodsAndParams);
        variableMethods.put(methodName, function);
    }

    private static Function<String, String> createNewFunction(Map<String, Function<String, String>> variableMethods, List<Map<String, String>> methodsAndParams) {
        return parameter -> {
            String result = parameter;
            for (Map methodAndParam : methodsAndParams) {
                String method;
                String params = (String)methodAndParam.get(method = (String)methodAndParam.keySet().toArray()[0]);
                if (params == null || params.length() == 0) {
                    result = (String)((Function)variableMethods.get(method)).apply(result);
                    continue;
                }
                result = (String)((Function)variableMethods.get(method)).apply(result + "," + params);
            }
            return result;
        };
    }

    private static List<Map<String, String>> getMethodsAndParams(String methodString) {
        LinkedList<Map<String, String>> methodsAndParams = new LinkedList<Map<String, String>>();
        while (methodString.indexOf("(") > 0 || methodString.length() > 0) {
            int bracketIndex = methodString.indexOf("(");
            int dotIndex = methodString.indexOf(".");
            int endOfStringIndex = methodString.length();
            int actualIndex = bracketIndex;
            if (actualIndex < 0) {
                actualIndex = dotIndex;
            } else if (dotIndex > 0) {
                actualIndex = Math.min(dotIndex, bracketIndex);
            }
            if (actualIndex < 0) {
                actualIndex = endOfStringIndex;
            }
            String intermediateMethodName = methodString.substring(0, actualIndex);
            String params = null;
            int endIndex = endOfStringIndex;
            if (actualIndex == bracketIndex) {
                int closeBracketIndex = methodString.indexOf(")");
                params = methodString.substring(bracketIndex + 1, closeBracketIndex);
                endIndex = closeBracketIndex + 1;
                if (endIndex < methodString.length()) {
                    ++endIndex;
                }
            } else if (actualIndex == dotIndex) {
                endIndex = actualIndex + 1;
            }
            HashMap<String, String> methodAndParam = new HashMap<String, String>();
            methodAndParam.put(intermediateMethodName, params);
            methodsAndParams.add(methodAndParam);
            methodString = methodString.substring(endIndex, methodString.length());
        }
        return methodsAndParams;
    }
}

