/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.List;
import java.util.Map;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;

public class VariableLoader {
    public static void loadConfigNumberedVariables(ModlValue value, Map<Integer, ModlValue> numberedVariables) {
        if (value != null) {
            if (value instanceof ModlObject.Array) {
                for (ModlValue val : ((ModlObject.Array)value).getValues()) {
                    VariableLoader.addConfigNumberedVariable(val, numberedVariables);
                }
            } else {
                VariableLoader.addConfigNumberedVariable(value, numberedVariables);
            }
        }
    }

    private static int addConfigNumberedVariable(ModlValue val, Map<Integer, ModlValue> numberedVariables) {
        int paramNum = numberedVariables.size();
        numberedVariables.put(paramNum, val);
        return paramNum;
    }

    private static void loadConfigVariable(List<ModlObject.Pair> mapItems, Map<String, ModlValue> variables) {
        for (ModlObject.Pair mapItem : mapItems) {
            VariableLoader.loadConfigVar(mapItem.getKey().string, mapItem, variables);
        }
    }

    public static void loadConfigVar(String key, ModlObject.Pair pair, Map<String, ModlValue> variables) {
        ModlValue v = pair.getModlValue();
        variables.put(key, v);
    }
}

