/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.Optional;
import java.util.UUID;
import org.json.JSONObject;

public class SendSmsResponse {
    private final UUID notificationId;
    private final String reference;
    private final UUID templateId;
    private final int templateVersion;
    private final String templateUri;
    private final String body;
    private final String fromNumber;

    public SendSmsResponse(String response) {
        JSONObject data = new JSONObject(response);
        this.notificationId = UUID.fromString(data.getString("id"));
        this.reference = data.isNull("reference") ? null : data.getString("reference");
        JSONObject content = data.getJSONObject("content");
        this.body = content.getString("body");
        this.fromNumber = content.isNull("from_number") ? null : content.getString("from_number");
        JSONObject template = data.getJSONObject("template");
        this.templateId = UUID.fromString(template.getString("id"));
        this.templateVersion = template.getInt("version");
        this.templateUri = template.getString("uri");
    }

    public UUID getNotificationId() {
        return this.notificationId;
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public UUID getTemplateId() {
        return this.templateId;
    }

    public int getTemplateVersion() {
        return this.templateVersion;
    }

    public String getTemplateUri() {
        return this.templateUri;
    }

    public String getBody() {
        return this.body;
    }

    public Optional<String> getFromNumber() {
        return Optional.ofNullable(this.fromNumber);
    }

    public String toString() {
        return "SendSmsResponse{notificationId=" + this.notificationId + ", reference=" + this.reference + ", templateId=" + this.templateId + ", templateVersion=" + this.templateVersion + ", templateUri='" + this.templateUri + '\'' + ", body='" + this.body + '\'' + ", fromNumber=" + this.fromNumber + '}';
    }
}

