/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.gov.service.notify.ReceivedTextMessage;

public class ReceivedTextMessageList {
    private final List<ReceivedTextMessage> receivedTextMessages;
    private final String currentPageLink;
    private final String nextPageLink;

    public ReceivedTextMessageList(String json) {
        JSONObject data = new JSONObject(json);
        JSONObject links = data.getJSONObject("links");
        this.currentPageLink = links.getString("current");
        this.nextPageLink = links.isNull("next") ? null : links.getString("next");
        this.receivedTextMessages = new ArrayList<ReceivedTextMessage>();
        JSONArray receivedTextMessagesData = data.getJSONArray("received_text_messages");
        for (int i = 0; i < receivedTextMessagesData.length(); ++i) {
            JSONObject receivedTextMessage = receivedTextMessagesData.getJSONObject(i);
            this.receivedTextMessages.add(new ReceivedTextMessage(receivedTextMessage));
        }
    }

    public List<ReceivedTextMessage> getReceivedTextMessages() {
        return this.receivedTextMessages;
    }

    public Optional<String> getNextPageLink() {
        return Optional.ofNullable(this.nextPageLink);
    }

    public String getCurrentPageLink() {
        return this.currentPageLink;
    }
}

