/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.UUID;
import org.json.JSONObject;
import uk.gov.service.notify.LetterResponse;

public class SendLetterResponse
extends LetterResponse {
    private UUID templateId;
    private int templateVersion;
    private String templateUri;
    private String body;
    private String subject;
    private JSONObject content = this.getData().getJSONObject("content");
    private JSONObject template;

    public SendLetterResponse(String response) {
        super(response);
        this.body = this.tryToGetString(this.content, "body");
        this.subject = this.tryToGetString(this.content, "subject");
        this.template = this.getData().getJSONObject("template");
        this.templateId = UUID.fromString(this.template.getString("id"));
        this.templateVersion = this.template.getInt("version");
        this.templateUri = this.template.getString("uri");
    }

    public UUID getTemplateId() {
        return this.templateId;
    }

    public int getTemplateVersion() {
        return this.templateVersion;
    }

    public String getTemplateUri() {
        return this.templateUri;
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public String toString() {
        return "SendLetterResponse{notificationId=" + this.getNotificationId() + ", reference=" + this.getReference() + ", templateId=" + this.templateId + ", templateVersion=" + this.templateVersion + ", templateUri='" + this.templateUri + '\'' + ", body='" + this.body + '\'' + ", subject='" + this.subject + '}';
    }
}

