/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.CancelOnDisconnectType;
import b3.entrypoint.fixp.sbe.DeltaInMillisDecoder;
import b3.entrypoint.fixp.sbe.EstablishRejectCode;
import b3.entrypoint.fixp.sbe.RetransmitRejectCode;
import b3.entrypoint.fixp.sbe.TerminationCode;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointContext;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointKey;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointProxy;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntrypointConnection;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FixPConnection;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.library.CancelOnDisconnect;
import uk.co.real_logic.artio.library.FixPSessionOwner;
import uk.co.real_logic.artio.library.InternalFixPConnection;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.protocol.GatewayPublication;

class InternalBinaryEntrypointConnection
extends InternalFixPConnection
implements BinaryEntrypointConnection {
    private static final UnsafeBuffer EMPTY_BUFFER = new UnsafeBuffer(new byte[0]);
    private final BinaryEntryPointProxy proxy;
    private final BinaryEntryPointContext context;
    private final long maxFixPKeepaliveTimeoutInMs;
    private final int maxRetransmissionRange;
    private final CancelOnDisconnect cancelOnDisconnect;
    private TerminationCode resendTerminationCode;
    private long sessionId;
    private long sessionVerId;
    private CancelOnDisconnectType cancelOnDisconnectType;
    private long codTimeoutWindow;
    private boolean suppressRedactResend = false;
    private boolean suppressRetransmissionResend = false;
    private boolean replaying = false;

    InternalBinaryEntrypointConnection(long connectionId, GatewayPublication outboundPublication, GatewayPublication inboundPublication, int libraryId, FixPSessionOwner owner, long lastReceivedSequenceNumber, long lastSentSequenceNumber, long lastConnectPayload, CommonConfiguration configuration, BinaryEntryPointContext context) {
        this(connectionId, outboundPublication, inboundPublication, libraryId, owner, lastReceivedSequenceNumber, lastSentSequenceNumber, lastConnectPayload, configuration, context, new BinaryEntryPointProxy(connectionId, outboundPublication.dataPublication(), configuration.epochNanoClock()));
    }

    InternalBinaryEntrypointConnection(long connectionId, GatewayPublication outboundPublication, GatewayPublication inboundPublication, int libraryId, FixPSessionOwner owner, long lastReceivedSequenceNumber, long lastSentSequenceNumber, long lastConnectPayload, CommonConfiguration configuration, BinaryEntryPointContext context, BinaryEntryPointProxy proxy) {
        super(connectionId, outboundPublication, inboundPublication, libraryId, configuration.epochNanoClock(), owner, (AbstractFixPProxy)proxy);
        this.maxFixPKeepaliveTimeoutInMs = configuration.maxFixPKeepaliveTimeoutInMs();
        this.context = context;
        this.proxy = (BinaryEntryPointProxy)((InternalFixPConnection)this).proxy;
        this.initialState(context);
        long timeInMs = System.currentTimeMillis();
        this.nextSendMessageTimeInMs = this.nextReceiveMessageTimeInMs = timeInMs + configuration.noEstablishFixPTimeoutInMs();
        this.requestedKeepAliveIntervalInMs = this.maxFixPKeepaliveTimeoutInMs;
        this.maxRetransmissionRange = configuration.fixPAcceptedSessionMaxRetransmissionRange();
        this.nextRecvSeqNo(this.adjustSeqNo(lastReceivedSequenceNumber));
        this.nextSentSeqNo(this.adjustSeqNo(lastSentSequenceNumber));
        this.cancelOnDisconnect = new CancelOnDisconnect(configuration.epochNanoClock(), true, deadlineInNs -> !Pressure.isBackPressured((long)outboundPublication.saveCancelOnDisconnectTrigger(context.sessionID(), deadlineInNs)));
        this.cancelOnDisconnect.enqueueTask(arg_0 -> ((FixPSessionOwner)owner).enqueueTask(arg_0));
    }

    private void initialState(BinaryEntryPointContext context) {
        this.state(context.fromNegotiate() ? FixPConnection.State.ACCEPTED : FixPConnection.State.NEGOTIATED_REESTABLISH);
    }

    private long adjustSeqNo(long lastReceivedSequenceNumber) {
        if (lastReceivedSequenceNumber == -1L) {
            return 1L;
        }
        return lastReceivedSequenceNumber + 1L;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    @Override
    public long sessionVerId() {
        return this.sessionVerId;
    }

    @Override
    public BinaryEntryPointKey key() {
        return this.context.key();
    }

    @Override
    public CancelOnDisconnectType cancelOnDisconnectType() {
        return this.cancelOnDisconnectType;
    }

    @Override
    public long codTimeoutWindow() {
        return this.codTimeoutWindow;
    }

    protected void keepAliveExpiredTerminate() {
        this.terminate(TerminationCode.UNSPECIFIED);
    }

    @Override
    public long terminate(TerminationCode terminationCode) {
        this.validateCanSend();
        return this.internalTerminateInclResend(terminationCode);
    }

    private long internalTerminateInclResend(TerminationCode terminationCode) {
        return this.sendTerminate(terminationCode, FixPConnection.State.UNBINDING, FixPConnection.State.RESEND_TERMINATE);
    }

    public long trySendSequence() {
        long position = this.proxy.sendSequence(this.sessionId, this.nextSentSeqNo);
        if (position > 0L) {
            this.onAttemptedToSendMessage();
        }
        return position;
    }

    protected int poll(long timeInMs) {
        switch (this.state) {
            case ACCEPTED: 
            case SENT_NEGOTIATE_RESPONSE: 
            case RETRY_NEGOTIATE_RESPONSE: 
            case NEGOTIATED_REESTABLISH: {
                if (timeInMs > this.nextReceiveMessageTimeInMs) {
                    this.fullyUnbind(DisconnectReason.AUTHENTICATION_TIMEOUT);
                }
                return 1;
            }
            case REPLIED_FINISHED_SENDING: 
            case SENT_FINISHED_SENDING: {
                if (timeInMs > this.nextSendMessageTimeInMs) {
                    this.finishSending();
                }
                return 1;
            }
            case RETRY_FINISHED_SENDING: 
            case RETRY_REPLY_FINISHED_SENDING: {
                this.finishSending();
                return 1;
            }
        }
        return this.commonPoll(this.state, timeInMs);
    }

    protected int pollExtraEstablished(long timeInMs) {
        return 0;
    }

    protected long sendSequence(boolean lapsed) {
        return this.trySendSequence();
    }

    protected void onReplayComplete() {
        this.replaying = false;
    }

    protected void onOfflineReconnect(long connectionId, FixPContext context) {
        this.initialState((BinaryEntryPointContext)context);
        this.connectionId = connectionId;
        this.proxy.ids(connectionId, this.sessionId);
    }

    public long onNegotiate(long sessionId, long sessionVerID, long timestamp, long enteringFirm, long onbehalfFirm, String senderLocation) {
        FixPConnection.State state = this.state();
        if (state == FixPConnection.State.UNBOUND) {
            this.onSessionId(sessionId, sessionVerID);
            return 1L;
        }
        if (state != FixPConnection.State.ACCEPTED && state != FixPConnection.State.SENT_NEGOTIATE_RESPONSE && this.checkFinishedSending(state)) {
            return 1L;
        }
        this.onSessionId(sessionId, sessionVerID);
        this.nextRecvSeqNo = 1L;
        this.nextSentSeqNo = 1L;
        long inboundPos = this.inboundPublication.saveRedactSequenceUpdate(sessionId, 0, -1000L);
        if (inboundPos < 0L) {
            return inboundPos;
        }
        long position = this.proxy.sendNegotiateResponse(sessionId, sessionVerID, timestamp, enteringFirm);
        this.onAttemptedToSendMessage();
        return this.checkState(position, FixPConnection.State.SENT_NEGOTIATE_RESPONSE, FixPConnection.State.RETRY_NEGOTIATE_RESPONSE);
    }

    private void onSessionId(long sessionId, long sessionVerID) {
        this.sessionId = sessionId;
        this.sessionVerId = sessionVerID;
        this.proxy.ids(this.connectionId, sessionId);
    }

    private long checkState(long position, FixPConnection.State success, FixPConnection.State backPressured) {
        if (position > 0L) {
            this.state(success);
        } else {
            this.state(backPressured);
        }
        return position;
    }

    public long onEstablish(long sessionID, long sessionVerID, long timestamp, long keepAliveIntervalInMs, long nextSeqNo, CancelOnDisconnectType cancelOnDisconnectType, long codTimeoutWindow) {
        FixPConnection.State state = this.state();
        if (state == FixPConnection.State.NEGOTIATED_REESTABLISH) {
            this.onSessionId(sessionID, sessionVerID);
        } else {
            this.checkSession(sessionID, sessionVerID);
            if (state != FixPConnection.State.SENT_NEGOTIATE_RESPONSE) {
                this.onAttemptedToSendMessage();
                return this.proxy.sendEstablishReject(sessionID, sessionVerID, timestamp, EstablishRejectCode.ALREADY_ESTABLISHED);
            }
            if (keepAliveIntervalInMs > this.maxFixPKeepaliveTimeoutInMs) {
                this.onAttemptedToSendMessage();
                long position = this.proxy.sendEstablishReject(sessionID, sessionVerID, timestamp, EstablishRejectCode.KEEPALIVE_INTERVAL);
                if (position > 0L) {
                    this.fullyUnbind();
                }
                return position;
            }
        }
        if (!this.suppressRedactResend) {
            this.onAttemptedToSendMessage();
            int correctSequenceNumber = (int)nextSeqNo - 1;
            long inboundPos = this.inboundPublication.saveRedactSequenceUpdate(this.sessionId, correctSequenceNumber, -1000L);
            if (inboundPos > 0L) {
                this.suppressRedactResend = true;
            } else {
                return inboundPos;
            }
        }
        long position = this.proxy.sendEstablishAck(sessionID, sessionVerID, timestamp, keepAliveIntervalInMs, nextSeqNo, this.nextRecvSeqNo - 1L);
        this.requestedKeepAliveIntervalInMs = keepAliveIntervalInMs;
        this.onAttemptedToSendMessage();
        this.onReceivedMessage();
        if (position > 0L) {
            this.setupCancelOnDisconnect(cancelOnDisconnectType, codTimeoutWindow);
            this.nextRecvSeqNo = nextSeqNo;
            this.suppressRedactResend = false;
            this.state(FixPConnection.State.ESTABLISHED);
        }
        return position;
    }

    private void setupCancelOnDisconnect(CancelOnDisconnectType type, long codTimeoutWindow) {
        if (type != CancelOnDisconnectType.DO_NOT_CANCEL_ON_DISCONNECT_OR_TERMINATE && codTimeoutWindow == DeltaInMillisDecoder.timeNullValue()) {
            this.setupCancelOnDisconnect(CancelOnDisconnectType.DO_NOT_CANCEL_ON_DISCONNECT_OR_TERMINATE, DeltaInMillisDecoder.timeNullValue());
        } else {
            CancelOnDisconnectOption option;
            this.cancelOnDisconnectType = type;
            switch (type) {
                case CANCEL_ON_DISCONNECT_ONLY: {
                    option = CancelOnDisconnectOption.CANCEL_ON_DISCONNECT_ONLY;
                    break;
                }
                case CANCEL_ON_TERMINATE_ONLY: {
                    option = CancelOnDisconnectOption.CANCEL_ON_LOGOUT_ONLY;
                    break;
                }
                case CANCEL_ON_DISCONNECT_OR_TERMINATE: {
                    option = CancelOnDisconnectOption.CANCEL_ON_DISCONNECT_OR_LOGOUT;
                    break;
                }
                default: {
                    option = CancelOnDisconnectOption.DO_NOT_CANCEL_ON_DISCONNECT_OR_LOGOUT;
                }
            }
            this.cancelOnDisconnect.cancelOnDisconnectOption(option);
            this.codTimeoutWindow = Math.min(60000L, codTimeoutWindow);
            this.cancelOnDisconnect.cancelOnDisconnectTimeoutWindowInNs(TimeUnit.MILLISECONDS.toNanos(this.codTimeoutWindow));
        }
    }

    public long onTerminate(long sessionID, long sessionVerID, TerminationCode terminationCode) {
        this.cancelOnDisconnect.checkCancelOnDisconnectLogout(this.clock.nanoTime());
        if (this.state == FixPConnection.State.UNBINDING) {
            this.fullyUnbind();
        } else {
            DebugLogger.log((LogTag)LogTag.FIXP_SESSION, (String)"Terminated: ", (String)terminationCode.name());
            this.sendTerminateAck(terminationCode);
        }
        this.checkSession(sessionID, sessionVerID);
        return 1L;
    }

    protected void unbindState(DisconnectReason reason) {
        this.cancelOnDisconnect.checkCancelOnDisconnectDisconnect();
        super.unbindState(reason);
    }

    private void checkSession(long sessionID, long sessionVerID) {
    }

    private void sendTerminateAck(TerminationCode terminationCode) {
        long position = this.sendTerminate(terminationCode, FixPConnection.State.UNBOUND, FixPConnection.State.RESEND_TERMINATE_ACK);
        if (position > 0L) {
            this.fullyUnbind();
        }
    }

    private long sendTerminate(TerminationCode terminationCode, FixPConnection.State finalState, FixPConnection.State resendState) {
        long position = this.proxy.sendTerminate(this.sessionId, this.sessionVerId, terminationCode, this.requestTimestampInNs());
        if (position > 0L) {
            this.state(finalState);
            this.resendTerminationCode = null;
        } else {
            this.state(resendState);
            this.resendTerminationCode = terminationCode;
        }
        return position;
    }

    public long onSequence(long nextSeqNo) {
        this.onReceivedMessage();
        if (this.checkFinishedSending(this.state)) {
            return 1L;
        }
        return this.checkSeqNo(nextSeqNo);
    }

    private long checkSeqNo(long nextSeqNo) {
        long nextRecvSeqNo = this.nextRecvSeqNo;
        if (nextSeqNo > nextRecvSeqNo) {
            long position = this.proxy.sendNotApplied(nextRecvSeqNo, nextSeqNo - nextRecvSeqNo, this.requestTimestampInNs());
            if (position > 0L) {
                this.nextRecvSeqNo = nextSeqNo;
            }
            return position;
        }
        if (nextSeqNo < nextRecvSeqNo) {
            return this.internalTerminateInclResend(TerminationCode.FINISHED);
        }
        return 1L;
    }

    public long onMessage(DirectBuffer buffer, int offset, int templateId, int blockLength, int version, int sofhMessageSize) {
        this.onReceivedMessage();
        FixPConnection.State state = this.state();
        if (state == FixPConnection.State.ESTABLISHED || state == FixPConnection.State.RETRANSMITTING || state == FixPConnection.State.AWAITING_KEEPALIVE) {
            ++this.nextRecvSeqNo;
            this.handler.onBusinessMessage((FixPConnection)this, templateId, buffer, offset, blockLength, version, false);
        } else {
            this.checkFinishedSending(state);
        }
        return 1L;
    }

    private boolean checkFinishedSending(FixPConnection.State state) {
        if (state == FixPConnection.State.RECV_FINISHED_SENDING || state == FixPConnection.State.REPLIED_FINISHED_SENDING || state == FixPConnection.State.RETRY_REPLY_FINISHED_SENDING) {
            this.internalTerminateInclResend(TerminationCode.UNSPECIFIED);
            return true;
        }
        return false;
    }

    @Override
    public void finishSending() {
        boolean theyInitiatedFinishedSending;
        FixPConnection.State state = this.state();
        boolean weInitiatedFinishedSending = state == FixPConnection.State.ESTABLISHED;
        boolean bl = theyInitiatedFinishedSending = state == FixPConnection.State.RECV_FINISHED_SENDING;
        if (weInitiatedFinishedSending || !theyInitiatedFinishedSending) {
            // empty if block
        }
        long position = this.proxy.sendFinishedSending(this.sessionId, this.sessionVerId, this.nextSentSeqNo - 1L, this.requestTimestampInNs());
        this.onAttemptedToSendMessage();
        if (weInitiatedFinishedSending) {
            this.checkState(position, FixPConnection.State.SENT_FINISHED_SENDING, FixPConnection.State.RETRY_FINISHED_SENDING);
        } else {
            this.checkState(position, FixPConnection.State.REPLIED_FINISHED_SENDING, FixPConnection.State.RETRY_REPLY_FINISHED_SENDING);
        }
    }

    public long onFinishedSending(long sessionID, long sessionVerID, long lastSeqNo) {
        boolean weInitiatedFinishedSending;
        FixPConnection.State state = this.state;
        boolean bl = weInitiatedFinishedSending = state == FixPConnection.State.RECV_FINISHED_RECEIVING_ONLY;
        if (state == FixPConnection.State.ESTABLISHED || !weInitiatedFinishedSending) {
            // empty if block
        }
        this.checkSession(sessionID, sessionVerID);
        long position = this.proxy.sendFinishedReceiving(sessionID, sessionVerID, this.requestTimestampInNs());
        if (position > 0L) {
            if (weInitiatedFinishedSending) {
                this.internalTerminateInclResend(TerminationCode.FINISHED);
            } else {
                this.state(FixPConnection.State.RECV_FINISHED_SENDING);
            }
            this.handler.onFinishedSending((FixPConnection)this);
        }
        return position;
    }

    public long onFinishedReceiving(long sessionID, long sessionVerID) {
        boolean theyInitiatedFinishedSending;
        FixPConnection.State state = this.state;
        boolean weInitiatedFinishedSending = state == FixPConnection.State.SENT_FINISHED_SENDING || state == FixPConnection.State.RETRY_FINISHED_SENDING;
        boolean bl = theyInitiatedFinishedSending = state == FixPConnection.State.REPLIED_FINISHED_SENDING;
        if (weInitiatedFinishedSending || !theyInitiatedFinishedSending) {
            // empty if block
        }
        this.checkSession(sessionID, sessionVerID);
        if (weInitiatedFinishedSending) {
            this.state(FixPConnection.State.RECV_FINISHED_RECEIVING_ONLY);
        } else {
            this.internalTerminateInclResend(TerminationCode.FINISHED);
        }
        return 1L;
    }

    public long onRetransmitRequest(long sessionID, long timestampInNs, long fromSeqNo, long count) {
        long position;
        FixPConnection.State state = this.state;
        if (state == FixPConnection.State.ESTABLISHED || state != FixPConnection.State.AWAITING_KEEPALIVE) {
            // empty if block
        }
        if (this.sessionId != sessionID) {
            return this.sendRetransmitReject(RetransmitRejectCode.INVALID_SESSION, timestampInNs);
        }
        if (this.maxRetransmissionRange != 0 && count > (long)this.maxRetransmissionRange) {
            return this.sendRetransmitReject(RetransmitRejectCode.REQUEST_LIMIT_EXCEEDED, timestampInNs);
        }
        long endSequenceNumber = fromSeqNo + count - 1L;
        if (endSequenceNumber >= this.nextSentSeqNo) {
            return this.sendRetransmitReject(RetransmitRejectCode.OUT_OF_RANGE, timestampInNs);
        }
        if (this.replaying) {
            return this.sendRetransmitReject(RetransmitRejectCode.REQUEST_LIMIT_EXCEEDED, timestampInNs);
        }
        if (!this.suppressRetransmissionResend && (position = this.proxy.sendRetransmission(fromSeqNo, count, this.requestTimestampInNs(), timestampInNs)) < 0L) {
            return position;
        }
        position = this.inboundPublication.saveValidResendRequest(sessionID, this.connectionId, fromSeqNo, endSequenceNumber, (int)this.sessionVerId, (DirectBuffer)EMPTY_BUFFER, 0, 0);
        if (position > 0L) {
            this.replaying = true;
        }
        this.suppressRetransmissionResend = position < 0L;
        return position;
    }

    private long sendRetransmitReject(RetransmitRejectCode rejectCode, long timestampInNs) {
        return this.proxy.sendRetransmitReject(rejectCode, this.requestTimestampInNs(), timestampInNs);
    }
}

