/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.AllocNoOrdersType;
import b3.entrypoint.fixp.sbe.AllocTransType;
import b3.entrypoint.fixp.sbe.AllocType;
import b3.entrypoint.fixp.sbe.AllocationInstructionDecoder;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.Side;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class AllocationInstructionEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 45;
    public static final int TEMPLATE_ID = 601;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AllocationInstructionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final NoExecsEncoder noExecs = new NoExecsEncoder(this);
    private final NoAllocsEncoder noAllocs = new NoAllocsEncoder(this);

    public int sbeBlockLength() {
        return 45;
    }

    public int sbeTemplateId() {
        return 601;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public AllocationInstructionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 45);
        return this;
    }

    public AllocationInstructionEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(45).templateId(601).schemaId(1).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int allocIDId() {
        return 70;
    }

    public static int allocIDSinceVersion() {
        return 0;
    }

    public static int allocIDEncodingOffset() {
        return 0;
    }

    public static int allocIDEncodingLength() {
        return 8;
    }

    public static String allocIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long allocIDNullValue() {
        return -1L;
    }

    public static long allocIDMinValue() {
        return 0L;
    }

    public static long allocIDMaxValue() {
        return -2L;
    }

    public AllocationInstructionEncoder allocID(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 8;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public AllocationInstructionEncoder securityID(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 16;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 16;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int quantityId() {
        return 53;
    }

    public static int quantitySinceVersion() {
        return 0;
    }

    public static int quantityEncodingOffset() {
        return 16;
    }

    public static int quantityEncodingLength() {
        return 8;
    }

    public static String quantityMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long quantityNullValue() {
        return -1L;
    }

    public static long quantityMinValue() {
        return 0L;
    }

    public static long quantityMaxValue() {
        return -2L;
    }

    public AllocationInstructionEncoder quantity(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 24;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public AllocationInstructionEncoder senderLocation(int index, byte value) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 24 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String senderLocationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public AllocationInstructionEncoder putSenderLocation(byte[] src, int srcOffset) {
        int length = 10;
        if (srcOffset < 0 || srcOffset > src.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 24, src, srcOffset, 10);
        return this;
    }

    public AllocationInstructionEncoder senderLocation(String src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 24, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 24 + start, (byte)0);
        }
        return this;
    }

    public AllocationInstructionEncoder senderLocation(CharSequence src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 24, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 24 + start, (byte)0);
        }
        return this;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 34;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public AllocationInstructionEncoder enteringTrader(int index, byte value) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 34 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public AllocationInstructionEncoder putEnteringTrader(byte[] src, int srcOffset) {
        int length = 5;
        if (srcOffset < 0 || srcOffset > src.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 34, src, srcOffset, 5);
        return this;
    }

    public AllocationInstructionEncoder enteringTrader(String src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 34, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 34 + start, (byte)0);
        }
        return this;
    }

    public AllocationInstructionEncoder enteringTrader(CharSequence src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 34, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 34 + start, (byte)0);
        }
        return this;
    }

    public static int tradeDateId() {
        return 75;
    }

    public static int tradeDateSinceVersion() {
        return 0;
    }

    public static int tradeDateEncodingOffset() {
        return 39;
    }

    public static int tradeDateEncodingLength() {
        return 2;
    }

    public static String tradeDateMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int tradeDateNullValue() {
        return 0;
    }

    public static int tradeDateMinValue() {
        return 0;
    }

    public static int tradeDateMaxValue() {
        return 65534;
    }

    public AllocationInstructionEncoder tradeDate(int value) {
        this.buffer.putShort(this.offset + 39, (short)value, BYTE_ORDER);
        return this;
    }

    public static int allocTransTypeId() {
        return 71;
    }

    public static int allocTransTypeSinceVersion() {
        return 0;
    }

    public static int allocTransTypeEncodingOffset() {
        return 41;
    }

    public static int allocTransTypeEncodingLength() {
        return 1;
    }

    public static String allocTransTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public AllocationInstructionEncoder allocTransType(AllocTransType value) {
        this.buffer.putByte(this.offset + 41, value.value());
        return this;
    }

    public static int allocTypeId() {
        return 626;
    }

    public static int allocTypeSinceVersion() {
        return 0;
    }

    public static int allocTypeEncodingOffset() {
        return 42;
    }

    public static int allocTypeEncodingLength() {
        return 1;
    }

    public static String allocTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public AllocationInstructionEncoder allocType(AllocType value) {
        this.buffer.putByte(this.offset + 42, value.value());
        return this;
    }

    public static int allocNoOrdersTypeId() {
        return 857;
    }

    public static int allocNoOrdersTypeSinceVersion() {
        return 0;
    }

    public static int allocNoOrdersTypeEncodingOffset() {
        return 43;
    }

    public static int allocNoOrdersTypeEncodingLength() {
        return 1;
    }

    public static String allocNoOrdersTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public AllocationInstructionEncoder allocNoOrdersType(AllocNoOrdersType value) {
        this.buffer.putByte(this.offset + 43, value.value());
        return this;
    }

    public static int sideId() {
        return 54;
    }

    public static int sideSinceVersion() {
        return 0;
    }

    public static int sideEncodingOffset() {
        return 44;
    }

    public static int sideEncodingLength() {
        return 1;
    }

    public static String sideMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public AllocationInstructionEncoder side(Side value) {
        this.buffer.putByte(this.offset + 44, value.value());
        return this;
    }

    public static long noExecsId() {
        return 124L;
    }

    public NoExecsEncoder noExecsCount(int count) {
        this.noExecs.wrap(this.buffer, count);
        return this.noExecs;
    }

    public static long noAllocsId() {
        return 78L;
    }

    public NoAllocsEncoder noAllocsCount(int count) {
        this.noAllocs.wrap(this.buffer, count);
        return this.noAllocs;
    }

    public static int deskIDId() {
        return 35510;
    }

    public static String deskIDCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String deskIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int deskIDHeaderLength() {
        return 1;
    }

    public AllocationInstructionEncoder putDeskID(DirectBuffer src, int srcOffset, int length) {
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public AllocationInstructionEncoder putDeskID(byte[] src, int srcOffset, int length) {
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public AllocationInstructionEncoder deskID(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public AllocationInstructionEncoder deskID(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public static int memoId() {
        return 5149;
    }

    public static String memoCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String memoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int memoHeaderLength() {
        return 1;
    }

    public AllocationInstructionEncoder putMemo(DirectBuffer src, int srcOffset, int length) {
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public AllocationInstructionEncoder putMemo(byte[] src, int srcOffset, int length) {
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public AllocationInstructionEncoder memo(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        AllocationInstructionDecoder decoder = new AllocationInstructionDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 45, 5);
        return decoder.appendTo(builder);
    }

    public static final class NoExecsEncoder {
        public static final int HEADER_SIZE = 3;
        private final AllocationInstructionEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NoExecsEncoder(AllocationInstructionEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)4, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NoExecsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NoExecsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 4;
        }

        public static int tradeIDId() {
            return 1003;
        }

        public static int tradeIDSinceVersion() {
            return 0;
        }

        public static int tradeIDEncodingOffset() {
            return 0;
        }

        public static int tradeIDEncodingLength() {
            return 4;
        }

        public static String tradeIDMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "optional";
            }
            return "";
        }

        public static long tradeIDNullValue() {
            return 0L;
        }

        public static long tradeIDMinValue() {
            return 0L;
        }

        public static long tradeIDMaxValue() {
            return 0xFFFFFFFEL;
        }

        public NoExecsEncoder tradeID(long value) {
            this.buffer.putInt(this.offset + 0, (int)value, BYTE_ORDER);
            return this;
        }
    }

    public static final class NoAllocsEncoder {
        public static final int HEADER_SIZE = 3;
        private final AllocationInstructionEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NoAllocsEncoder(AllocationInstructionEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)20, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NoAllocsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NoAllocsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 20;
        }

        public static int individualAllocIDId() {
            return 467;
        }

        public static int individualAllocIDSinceVersion() {
            return 0;
        }

        public static int individualAllocIDEncodingOffset() {
            return 0;
        }

        public static int individualAllocIDEncodingLength() {
            return 8;
        }

        public static String individualAllocIDMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long individualAllocIDNullValue() {
            return -1L;
        }

        public static long individualAllocIDMinValue() {
            return 0L;
        }

        public static long individualAllocIDMaxValue() {
            return -2L;
        }

        public NoAllocsEncoder individualAllocID(long value) {
            this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static int allocAccountId() {
            return 79;
        }

        public static int allocAccountSinceVersion() {
            return 0;
        }

        public static int allocAccountEncodingOffset() {
            return 8;
        }

        public static int allocAccountEncodingLength() {
            return 4;
        }

        public static String allocAccountMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "optional";
            }
            return "";
        }

        public static long allocAccountNullValue() {
            return 0L;
        }

        public static long allocAccountMinValue() {
            return 0L;
        }

        public static long allocAccountMaxValue() {
            return 0xFFFFFFFEL;
        }

        public NoAllocsEncoder allocAccount(long value) {
            this.buffer.putInt(this.offset + 8, (int)value, BYTE_ORDER);
            return this;
        }

        public static int allocQtyId() {
            return 80;
        }

        public static int allocQtySinceVersion() {
            return 0;
        }

        public static int allocQtyEncodingOffset() {
            return 12;
        }

        public static int allocQtyEncodingLength() {
            return 8;
        }

        public static String allocQtyMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long allocQtyNullValue() {
            return -1L;
        }

        public static long allocQtyMinValue() {
            return 0L;
        }

        public static long allocQtyMaxValue() {
            return -2L;
        }

        public NoAllocsEncoder allocQty(long value) {
            this.buffer.putLong(this.offset + 12, value, BYTE_ORDER);
            return this;
        }
    }
}

