/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.CompositeDecoderFlyweight;

public final class FramingHeaderDecoder
implements CompositeDecoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final int ENCODED_LENGTH = 4;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public FramingHeaderDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 4;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public static int messageLengthEncodingOffset() {
        return 0;
    }

    public static int messageLengthEncodingLength() {
        return 2;
    }

    public static int messageLengthSinceVersion() {
        return 0;
    }

    public static int messageLengthNullValue() {
        return 65535;
    }

    public static int messageLengthMinValue() {
        return 12;
    }

    public static int messageLengthMaxValue() {
        return 2048;
    }

    public int messageLength() {
        return this.buffer.getShort(this.offset + 0, BYTE_ORDER) & 0xFFFF;
    }

    public static int encodingTypeEncodingOffset() {
        return 2;
    }

    public static int encodingTypeEncodingLength() {
        return 2;
    }

    public static int encodingTypeSinceVersion() {
        return 0;
    }

    public static int encodingTypeNullValue() {
        return 65535;
    }

    public static int encodingTypeMinValue() {
        return 0;
    }

    public static int encodingTypeMaxValue() {
        return 65534;
    }

    public int encodingType() {
        return this.buffer.getShort(this.offset + 2, BYTE_ORDER) & 0xFFFF;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("messageLength=");
        builder.append(this.messageLength());
        builder.append('|');
        builder.append("encodingType=");
        builder.append(this.encodingType());
        builder.append(')');
        return builder;
    }
}

