/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.NegotiateDecoder;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosEncoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class NegotiateEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NegotiateEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final UTCTimestampNanosEncoder timestamp = new UTCTimestampNanosEncoder();

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NegotiateEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 28);
        return this;
    }

    public NegotiateEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(28).templateId(1).schemaId(1).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int sessionIDId() {
        return 35518;
    }

    public static int sessionIDSinceVersion() {
        return 0;
    }

    public static int sessionIDEncodingOffset() {
        return 0;
    }

    public static int sessionIDEncodingLength() {
        return 4;
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIDNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long sessionIDMinValue() {
        return 0L;
    }

    public static long sessionIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public NegotiateEncoder sessionID(long value) {
        this.buffer.putInt(this.offset + 0, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionVerIDId() {
        return 35519;
    }

    public static int sessionVerIDSinceVersion() {
        return 0;
    }

    public static int sessionVerIDEncodingOffset() {
        return 4;
    }

    public static int sessionVerIDEncodingLength() {
        return 8;
    }

    public static String sessionVerIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionVerIDNullValue() {
        return -1L;
    }

    public static long sessionVerIDMinValue() {
        return 0L;
    }

    public static long sessionVerIDMaxValue() {
        return -2L;
    }

    public NegotiateEncoder sessionVerID(long value) {
        this.buffer.putLong(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int timestampId() {
        return 35520;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 12;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosEncoder timestamp() {
        this.timestamp.wrap(this.buffer, this.offset + 12);
        return this.timestamp;
    }

    public static int clientFlowId() {
        return 35516;
    }

    public static int clientFlowSinceVersion() {
        return 0;
    }

    public static int clientFlowEncodingOffset() {
        return 20;
    }

    public static int clientFlowEncodingLength() {
        return 1;
    }

    public static String clientFlowMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int enteringFirmId() {
        return 35501;
    }

    public static int enteringFirmSinceVersion() {
        return 0;
    }

    public static int enteringFirmEncodingOffset() {
        return 20;
    }

    public static int enteringFirmEncodingLength() {
        return 4;
    }

    public static String enteringFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long enteringFirmNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long enteringFirmMinValue() {
        return 0L;
    }

    public static long enteringFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public NegotiateEncoder enteringFirm(long value) {
        this.buffer.putInt(this.offset + 20, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int onbehalfFirmId() {
        return 35517;
    }

    public static int onbehalfFirmSinceVersion() {
        return 0;
    }

    public static int onbehalfFirmEncodingOffset() {
        return 24;
    }

    public static int onbehalfFirmEncodingLength() {
        return 4;
    }

    public static String onbehalfFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long onbehalfFirmNullValue() {
        return 0L;
    }

    public static long onbehalfFirmMinValue() {
        return 0L;
    }

    public static long onbehalfFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public NegotiateEncoder onbehalfFirm(long value) {
        this.buffer.putInt(this.offset + 24, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int credentialsId() {
        return 35512;
    }

    public static String credentialsCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String credentialsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int credentialsHeaderLength() {
        return 1;
    }

    public NegotiateEncoder putCredentials(DirectBuffer src, int srcOffset, int length) {
        if (length > 128) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public NegotiateEncoder putCredentials(byte[] src, int srcOffset, int length) {
        if (length > 128) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public NegotiateEncoder credentials(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 128) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int clientIPId() {
        return 35513;
    }

    public static String clientIPCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String clientIPMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int clientIPHeaderLength() {
        return 1;
    }

    public NegotiateEncoder putClientIP(DirectBuffer src, int srcOffset, int length) {
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public NegotiateEncoder putClientIP(byte[] src, int srcOffset, int length) {
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public NegotiateEncoder clientIP(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public NegotiateEncoder clientIP(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public static int clientAppNameId() {
        return 35514;
    }

    public static String clientAppNameCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String clientAppNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int clientAppNameHeaderLength() {
        return 1;
    }

    public NegotiateEncoder putClientAppName(DirectBuffer src, int srcOffset, int length) {
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public NegotiateEncoder putClientAppName(byte[] src, int srcOffset, int length) {
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public NegotiateEncoder clientAppName(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public NegotiateEncoder clientAppName(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public static int clientAppVersionId() {
        return 35515;
    }

    public static String clientAppVersionCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String clientAppVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int clientAppVersionHeaderLength() {
        return 1;
    }

    public NegotiateEncoder putClientAppVersion(DirectBuffer src, int srcOffset, int length) {
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public NegotiateEncoder putClientAppVersion(byte[] src, int srcOffset, int length) {
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public NegotiateEncoder clientAppVersion(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public NegotiateEncoder clientAppVersion(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 30) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        NegotiateDecoder decoder = new NegotiateDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 28, 5);
        return decoder.appendTo(builder);
    }
}

