/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class BusinessMessageRejectDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 17;
    public static final int TEMPLATE_ID = 206;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BusinessMessageRejectDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 17;
    }

    public int sbeTemplateId() {
        return 206;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public BusinessMessageRejectDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public BusinessMessageRejectDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (206 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public BusinessMessageRejectDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.BusinessMessageReject.value();
    }

    public MessageType messageType() {
        return MessageType.BusinessMessageReject;
    }

    public static int refSeqNumId() {
        return 45;
    }

    public static int refSeqNumSinceVersion() {
        return 0;
    }

    public static int refSeqNumEncodingOffset() {
        return 0;
    }

    public static int refSeqNumEncodingLength() {
        return 4;
    }

    public static String refSeqNumMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long refSeqNumNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long refSeqNumMinValue() {
        return 0L;
    }

    public static long refSeqNumMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long refSeqNum() {
        return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int refMsgTypeId() {
        return 372;
    }

    public static int refMsgTypeSinceVersion() {
        return 0;
    }

    public static int refMsgTypeEncodingOffset() {
        return 4;
    }

    public static int refMsgTypeEncodingLength() {
        return 1;
    }

    public static String refMsgTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short refMsgTypeRaw() {
        return (short)(this.buffer.getByte(this.offset + 4) & 0xFF);
    }

    public MessageType refMsgType() {
        return MessageType.get((short)(this.buffer.getByte(this.offset + 4) & 0xFF));
    }

    public static int businessRejectRefIDId() {
        return 379;
    }

    public static int businessRejectRefIDSinceVersion() {
        return 0;
    }

    public static int businessRejectRefIDEncodingOffset() {
        return 5;
    }

    public static int businessRejectRefIDEncodingLength() {
        return 8;
    }

    public static String businessRejectRefIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long businessRejectRefIDNullValue() {
        return 0L;
    }

    public static long businessRejectRefIDMinValue() {
        return 0L;
    }

    public static long businessRejectRefIDMaxValue() {
        return -2L;
    }

    public long businessRejectRefID() {
        return this.buffer.getLong(this.offset + 5, ByteOrder.LITTLE_ENDIAN);
    }

    public static int businessRejectReasonId() {
        return 380;
    }

    public static int businessRejectReasonSinceVersion() {
        return 0;
    }

    public static int businessRejectReasonEncodingOffset() {
        return 13;
    }

    public static int businessRejectReasonEncodingLength() {
        return 4;
    }

    public static String businessRejectReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long businessRejectReasonNullValue() {
        return 0L;
    }

    public static long businessRejectReasonMinValue() {
        return 0L;
    }

    public static long businessRejectReasonMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long businessRejectReason() {
        return (long)this.buffer.getInt(this.offset + 13, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int textId() {
        return 58;
    }

    public static int textSinceVersion() {
        return 0;
    }

    public static String textCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String textMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int textHeaderLength() {
        return 1;
    }

    public int textLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipText() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getText(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getText(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapText(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String text() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getText(Appendable appendable) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, (int)dataLength, appendable);
        return dataLength;
    }

    public static int memoId() {
        return 5149;
    }

    public static int memoSinceVersion() {
        return 0;
    }

    public static String memoCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String memoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int memoHeaderLength() {
        return 1;
    }

    public int memoLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipMemo() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMemo(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMemo(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMemo(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String memo() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        BusinessMessageRejectDecoder decoder = new BusinessMessageRejectDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[BusinessMessageReject](sbeTemplateId=");
        builder.append(206);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 17) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(17);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("refSeqNum=");
        builder.append(this.refSeqNum());
        builder.append('|');
        builder.append("refMsgType=");
        builder.append((Object)this.refMsgType());
        builder.append('|');
        builder.append("businessRejectRefID=");
        builder.append(this.businessRejectRefID());
        builder.append('|');
        builder.append("businessRejectReason=");
        builder.append(this.businessRejectReason());
        builder.append('|');
        builder.append("text=");
        builder.append('\'');
        this.getText(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("memo=");
        builder.append('\'').append(this.memo()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public BusinessMessageRejectDecoder sbeSkip() {
        this.sbeRewind();
        this.skipText();
        this.skipMemo();
        return this;
    }
}

