/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.FlowType;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosDecoder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class NegotiateDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 38;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NegotiateDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final UTCTimestampNanosDecoder timestamp = new UTCTimestampNanosDecoder();

    public int sbeBlockLength() {
        return 38;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NegotiateDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public NegotiateDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (1 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public NegotiateDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.Negotiate.value();
    }

    public MessageType messageType() {
        return MessageType.Negotiate;
    }

    public static int sessionIDId() {
        return 35518;
    }

    public static int sessionIDSinceVersion() {
        return 0;
    }

    public static int sessionIDEncodingOffset() {
        return 0;
    }

    public static int sessionIDEncodingLength() {
        return 4;
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIDNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long sessionIDMinValue() {
        return 0L;
    }

    public static long sessionIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long sessionID() {
        return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int sessionVerIDId() {
        return 35519;
    }

    public static int sessionVerIDSinceVersion() {
        return 0;
    }

    public static int sessionVerIDEncodingOffset() {
        return 4;
    }

    public static int sessionVerIDEncodingLength() {
        return 8;
    }

    public static String sessionVerIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionVerIDNullValue() {
        return -1L;
    }

    public static long sessionVerIDMinValue() {
        return 0L;
    }

    public static long sessionVerIDMaxValue() {
        return -2L;
    }

    public long sessionVerID() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int timestampId() {
        return 35520;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 12;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosDecoder timestamp() {
        this.timestamp.wrap(this.buffer, this.offset + 12);
        return this.timestamp;
    }

    public static int clientFlowId() {
        return 35516;
    }

    public static int clientFlowSinceVersion() {
        return 0;
    }

    public static int clientFlowEncodingOffset() {
        return 20;
    }

    public static int clientFlowEncodingLength() {
        return 1;
    }

    public static String clientFlowMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short clientFlowRaw() {
        return FlowType.IDEMPOTENT.value();
    }

    public FlowType clientFlow() {
        return FlowType.IDEMPOTENT;
    }

    public static int enteringFirmId() {
        return 35501;
    }

    public static int enteringFirmSinceVersion() {
        return 0;
    }

    public static int enteringFirmEncodingOffset() {
        return 20;
    }

    public static int enteringFirmEncodingLength() {
        return 4;
    }

    public static String enteringFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long enteringFirmNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long enteringFirmMinValue() {
        return 0L;
    }

    public static long enteringFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long enteringFirm() {
        return (long)this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int onbehalfFirmId() {
        return 35517;
    }

    public static int onbehalfFirmSinceVersion() {
        return 0;
    }

    public static int onbehalfFirmEncodingOffset() {
        return 24;
    }

    public static int onbehalfFirmEncodingLength() {
        return 4;
    }

    public static String onbehalfFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long onbehalfFirmNullValue() {
        return 0L;
    }

    public static long onbehalfFirmMinValue() {
        return 0L;
    }

    public static long onbehalfFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long onbehalfFirm() {
        return (long)this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 28;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public byte senderLocation(int index) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 28 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String senderLocationCharacterEncoding() {
        return "ASCII";
    }

    public int getSenderLocation(byte[] dst, int dstOffset) {
        int length = 10;
        if (dstOffset < 0 || dstOffset > dst.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 28, dst, dstOffset, 10);
        return 10;
    }

    public String senderLocation() {
        int end;
        byte[] dst = new byte[10];
        this.buffer.getBytes(this.offset + 28, dst, 0, 10);
        for (end = 0; end < 10 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getSenderLocation(Appendable value) {
        for (int i = 0; i < 10; ++i) {
            int c = this.buffer.getByte(this.offset + 28 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 10;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        NegotiateDecoder decoder = new NegotiateDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[Negotiate](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 38) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(38);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("sessionID=");
        builder.append(this.sessionID());
        builder.append('|');
        builder.append("sessionVerID=");
        builder.append(this.sessionVerID());
        builder.append('|');
        builder.append("timestamp=");
        UTCTimestampNanosDecoder timestamp = this.timestamp();
        if (timestamp != null) {
            timestamp.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("clientFlow=");
        builder.append((Object)this.clientFlow());
        builder.append('|');
        builder.append("enteringFirm=");
        builder.append(this.enteringFirm());
        builder.append('|');
        builder.append("onbehalfFirm=");
        builder.append(this.onbehalfFirm());
        builder.append('|');
        builder.append("senderLocation=");
        for (int i = 0; i < NegotiateDecoder.senderLocationLength() && this.senderLocation(i) > 0; ++i) {
            builder.append((char)this.senderLocation(i));
        }
        this.limit(originalLimit);
        return builder;
    }

    public NegotiateDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

