/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.DeltaInMillisDecoder;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class EstablishAckDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final EstablishAckDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final UTCTimestampNanosDecoder requestTimestamp = new UTCTimestampNanosDecoder();
    private final DeltaInMillisDecoder keepAliveInterval = new DeltaInMillisDecoder();

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 5;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public EstablishAckDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public EstablishAckDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (5 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public EstablishAckDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.EstablishAck.value();
    }

    public MessageType messageType() {
        return MessageType.EstablishAck;
    }

    public static int sessionIDId() {
        return 35518;
    }

    public static int sessionIDSinceVersion() {
        return 0;
    }

    public static int sessionIDEncodingOffset() {
        return 0;
    }

    public static int sessionIDEncodingLength() {
        return 4;
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIDNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long sessionIDMinValue() {
        return 0L;
    }

    public static long sessionIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long sessionID() {
        return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int sessionVerIDId() {
        return 35519;
    }

    public static int sessionVerIDSinceVersion() {
        return 0;
    }

    public static int sessionVerIDEncodingOffset() {
        return 4;
    }

    public static int sessionVerIDEncodingLength() {
        return 8;
    }

    public static String sessionVerIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionVerIDNullValue() {
        return -1L;
    }

    public static long sessionVerIDMinValue() {
        return 0L;
    }

    public static long sessionVerIDMaxValue() {
        return -2L;
    }

    public long sessionVerID() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int requestTimestampId() {
        return 35521;
    }

    public static int requestTimestampSinceVersion() {
        return 0;
    }

    public static int requestTimestampEncodingOffset() {
        return 12;
    }

    public static int requestTimestampEncodingLength() {
        return 8;
    }

    public static String requestTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosDecoder requestTimestamp() {
        this.requestTimestamp.wrap(this.buffer, this.offset + 12);
        return this.requestTimestamp;
    }

    public static int keepAliveIntervalId() {
        return 35525;
    }

    public static int keepAliveIntervalSinceVersion() {
        return 0;
    }

    public static int keepAliveIntervalEncodingOffset() {
        return 20;
    }

    public static int keepAliveIntervalEncodingLength() {
        return 8;
    }

    public static String keepAliveIntervalMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public DeltaInMillisDecoder keepAliveInterval() {
        this.keepAliveInterval.wrap(this.buffer, this.offset + 20);
        return this.keepAliveInterval;
    }

    public static int nextSeqNoId() {
        return 35526;
    }

    public static int nextSeqNoSinceVersion() {
        return 0;
    }

    public static int nextSeqNoEncodingOffset() {
        return 28;
    }

    public static int nextSeqNoEncodingLength() {
        return 4;
    }

    public static String nextSeqNoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long nextSeqNoNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long nextSeqNoMinValue() {
        return 0L;
    }

    public static long nextSeqNoMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long nextSeqNo() {
        return (long)this.buffer.getInt(this.offset + 28, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int lastIncomingSeqNoId() {
        return 35527;
    }

    public static int lastIncomingSeqNoSinceVersion() {
        return 0;
    }

    public static int lastIncomingSeqNoEncodingOffset() {
        return 32;
    }

    public static int lastIncomingSeqNoEncodingLength() {
        return 4;
    }

    public static String lastIncomingSeqNoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastIncomingSeqNoNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long lastIncomingSeqNoMinValue() {
        return 0L;
    }

    public static long lastIncomingSeqNoMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long lastIncomingSeqNo() {
        return (long)this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        EstablishAckDecoder decoder = new EstablishAckDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[EstablishAck](sbeTemplateId=");
        builder.append(5);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 36) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(36);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("sessionID=");
        builder.append(this.sessionID());
        builder.append('|');
        builder.append("sessionVerID=");
        builder.append(this.sessionVerID());
        builder.append('|');
        builder.append("requestTimestamp=");
        UTCTimestampNanosDecoder requestTimestamp = this.requestTimestamp();
        if (requestTimestamp != null) {
            requestTimestamp.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("keepAliveInterval=");
        DeltaInMillisDecoder keepAliveInterval = this.keepAliveInterval();
        if (keepAliveInterval != null) {
            keepAliveInterval.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("nextSeqNo=");
        builder.append(this.nextSeqNo());
        builder.append('|');
        builder.append("lastIncomingSeqNo=");
        builder.append(this.lastIncomingSeqNo());
        this.limit(originalLimit);
        return builder;
    }

    public EstablishAckDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

