/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.util.concurrent.Futures;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import uk.co.coen.capsulecrm.client.CCustomField;
import uk.co.coen.capsulecrm.client.CCustomFieldDefinitions;
import uk.co.coen.capsulecrm.client.CCustomFields;
import uk.co.coen.capsulecrm.client.CHistory;
import uk.co.coen.capsulecrm.client.CHistoryItem;
import uk.co.coen.capsulecrm.client.CTag;
import uk.co.coen.capsulecrm.client.CTags;
import uk.co.coen.capsulecrm.client.CTask;
import uk.co.coen.capsulecrm.client.SimpleCapsuleEntity;
import uk.co.coen.capsulecrm.client.utils.ListenableFutureAdapter;
import uk.co.coen.capsulecrm.client.utils.ThrowOnHttpFailure;
import uk.co.coen.capsulecrm.client.utils.UnmarshalResponseBody;

public abstract class CapsuleEntity
extends SimpleCapsuleEntity {
    public DateTime createdOn;
    public DateTime updatedOn;

    public Future<CCustomFields> listCustomFields() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/customfields").addHeader("Accept", "application/xml").setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public Future<CCustomFieldDefinitions> listCustomFieldDefinitions() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/customfield/definitions").addHeader("Accept", "application/xml").setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public Future<Response> add(CCustomField cCustomField) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePut(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/customfields").addHeader("Content-Type", "application/xml").setRealm(CapsuleEntity.getRealm())).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)new CCustomFields(cCustomField))).execute((AsyncHandler)new ThrowOnHttpFailure());
    }

    public Future<Response> remove(CCustomField cCustomField) throws IOException {
        cCustomField.text = null;
        cCustomField.date = null;
        cCustomField.bool = null;
        cCustomField.number = null;
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePut(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/customfields").addHeader("Content-Type", "application/xml").setRealm(CapsuleEntity.getRealm())).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)new CCustomFields(cCustomField))).execute((AsyncHandler)new ThrowOnHttpFailure());
    }

    public Future<CHistory> listHistory() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/history").addHeader("Accept", "application/xml").setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public Future<Response> add(final CHistoryItem cHistoryItem) throws IOException {
        if (cHistoryItem.id != null) {
            return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePut(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/history/" + cHistoryItem.id).addHeader("Content-Type", "application/xml").setRealm(CapsuleEntity.getRealm())).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cHistoryItem)).execute((AsyncHandler)new ThrowOnHttpFailure());
        }
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/history").addHeader("Content-Type", "application/xml").setRealm(CapsuleEntity.getRealm())).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cHistoryItem)).execute((AsyncHandler)new ThrowOnHttpFailure(){

            @Override
            public Response onCompleted(Response response) throws Exception {
                String string = (response = super.onCompleted(response)).getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to history item " + (Object)((Object)this) + ", status is " + response.getStatusCode() + " " + response.getStatusText());
                }
                cHistoryItem.id = Long.parseLong(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }

    public Future<Response> remove(CHistoryItem cHistoryItem) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareDelete(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/history/" + cHistoryItem.id).setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure());
    }

    public Future<CTags> listTags() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/tag").addHeader("Accept", "application/xml").setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public Future<Response> add(CTag cTag) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/tag/" + cTag.name).setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure());
    }

    public Future<Response> addTag(String string) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/tag/" + string).setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure());
    }

    public Future<Response> remove(CTag cTag) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareDelete(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/tag/" + cTag.name).setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure());
    }

    public Future<Response> removeTag(String string) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareDelete(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/tag/" + string).setRealm(CapsuleEntity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure());
    }

    public Future<Response> add(final CTask cTask) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(CapsuleEntity.getCapsuleUrl() + "/api" + this.readContextPath() + "/" + this.id + "/task").addHeader("Content-Type", "application/xml").setRealm(CapsuleEntity.getRealm())).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cTask)).execute((AsyncHandler)new ThrowOnHttpFailure(){

            @Override
            public Response onCompleted(Response response) throws Exception {
                String string = (response = super.onCompleted(response)).getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to task " + (Object)((Object)this) + ", status is " + response.getStatusCode() + " " + response.getStatusText());
                }
                cTask.id = Long.parseLong(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }
}

