/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.Futures;
import com.ning.http.client.AsyncHttpClient;
import java.io.IOException;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import uk.co.coen.capsulecrm.client.CMilestones;
import uk.co.coen.capsulecrm.client.COpportunities;
import uk.co.coen.capsulecrm.client.CParty;
import uk.co.coen.capsulecrm.client.CapsuleEntity;
import uk.co.coen.capsulecrm.client.utils.ListenableFutureAdapter;
import uk.co.coen.capsulecrm.client.utils.UnmarshalResponseBody;

public class COpportunity
extends CapsuleEntity {
    public String name;
    public String description;
    public Integer partyId;
    public String currency;
    public String value;
    public String durationBasis;
    public Integer duration;
    public DateTime expectedCloseDate;
    public Integer milestoneId;
    public String milestone;
    public String probability;
    public String owner;
    public Integer trackId;

    @Override
    protected String readContextPath() {
        return "/opportunity";
    }

    @Override
    protected String writeContextPath() {
        return "/party/" + this.partyId + "/opportunity";
    }

    public static Future<CMilestones> listMilestones() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/opportunity/milestones").addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listAll() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/opportunity").addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listByTag(String string) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/opportunity").addQueryParameter("tag", string).addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listModifiedSince(DateTime dateTime) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/opportunity").addQueryParameter("lastmodified", dateTime.toString("yyyyMMdd'T'HHmmss")).addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listByParty(CParty cParty) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api/party/" + cParty.id + "/opportunity").addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("partyId", (Object)this.partyId).add("currency", (Object)this.currency).add("value", (Object)this.value).add("durationBasis", (Object)this.durationBasis).add("duration", (Object)this.duration).add("expectedCloseDate", (Object)this.expectedCloseDate).add("milestoneId", (Object)this.milestoneId).add("milestone", (Object)this.milestone).add("probability", (Object)this.probability).add("owner", (Object)this.owner).add("trackId", (Object)this.trackId).toString();
    }
}

