/*
 * Decompiled with CFR 0.152.
 */
package gate.test;

import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.Plugin;
import gate.test.GATEPluginTestCase;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashSet;

public abstract class GappLoadingTestCase
extends GATEPluginTestCase {
    String[] excluded = null;

    public GappLoadingTestCase(String ... excluded) {
        this.excluded = excluded;
    }

    public void testGappLoading() throws Exception {
        URL creoleURL = ((Object)((Object)this)).getClass().getResource("/creole.xml");
        URL resourcesURL = new URL(creoleURL, "resources");
        Path pathInPlugin = Paths.get(resourcesURL.toURI());
        if (Files.exists(pathInPlugin, new LinkOption[0])) {
            Files.walkFileTree(pathInPlugin, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                    String filename = filePath.getFileName().toString().toLowerCase();
                    if (filename.endsWith(".gapp") || filename.endsWith(".xgapp")) {
                        boolean shouldTest = true;
                        for (String exclude : GappLoadingTestCase.this.excluded) {
                            shouldTest &= !filePath.endsWith(exclude);
                        }
                        if (shouldTest) {
                            System.out.println("Trying to load " + filePath);
                            Object obj = null;
                            try {
                                obj = PersistenceManager.loadObjectFromFile((File)filePath.toFile());
                            }
                            catch (Exception e) {
                                throw new IOException(e);
                            }
                            finally {
                                if (obj instanceof Resource) {
                                    Factory.deleteResource((Resource)((Resource)obj));
                                }
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        LinkedHashSet plugins = new LinkedHashSet(Gate.getCreoleRegister().getPlugins());
        try (PrintWriter out = new PrintWriter(new File(gate.util.Files.fileFromURL((URL)creoleURL).getParentFile().getParentFile(), "creole-dependencies.txt"));){
            out.println(GappLoadingTestCase.generatePluginLabel((Plugin)this.pluginUnderTest));
            for (Plugin plugin : Gate.getCreoleRegister().getPlugins()) {
                if (!plugin.equals((Object)this.pluginUnderTest)) {
                    out.println(GappLoadingTestCase.generatePluginLabel(plugin));
                }
                for (Plugin required : plugin.getRequiredPlugins()) {
                    plugins.remove(required);
                }
            }
        }
        out = new PrintWriter(new File(gate.util.Files.fileFromURL((URL)creoleURL).getParentFile().getParentFile(), "creole-dependencies.gv"));
        var6_6 = null;
        try {
            out.println("digraph G {");
            out.println("   // ensure we always include this plugin even if no dependencies");
            out.println("   \"" + GappLoadingTestCase.generatePluginLabel((Plugin)this.pluginUnderTest) + "\"\n");
            for (Plugin plugin : plugins) {
                GappLoadingTestCase.dumpPluginHierarchy(out, plugin, "[color=red]");
                if (plugin.equals((Object)this.pluginUnderTest)) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("   \"").append(GappLoadingTestCase.generatePluginLabel((Plugin)this.pluginUnderTest)).append("\" -> \"").append(GappLoadingTestCase.generatePluginLabel(plugin)).append("\" [color=green]\n");
                out.println(builder.toString());
            }
            out.println("}");
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var6_6 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    private static void dumpPluginHierarchy(PrintWriter out, Plugin plugin, String formatting) {
        StringBuilder builder = new StringBuilder();
        for (Plugin required : plugin.getRequiredPlugins()) {
            builder.append("   \"").append(GappLoadingTestCase.generatePluginLabel(plugin)).append("\" -> \"").append(GappLoadingTestCase.generatePluginLabel(required)).append("\"");
            if (formatting != null && !formatting.isEmpty()) {
                builder.append(" ").append(formatting);
            }
            builder.append("\n");
        }
        out.print(builder.toString());
    }

    private static String generatePluginLabel(Plugin plugin) {
        StringBuilder builder = new StringBuilder();
        if (plugin instanceof Plugin.Maven) {
            Plugin.Maven mavenPlugin = (Plugin.Maven)plugin;
            builder.append(mavenPlugin.getGroup()).append(":").append(mavenPlugin.getArtifact()).append(":").append(mavenPlugin.getVersion());
        } else {
            builder.append(plugin.getClass()).append(":").append(plugin.getName()).append(":").append(plugin.getVersion());
        }
        return builder.toString();
    }
}

