/*
 * Decompiled with CFR 0.152.
 */
package tw.com.tp6gl4cj86.image_tool;

import android.app.DownloadManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.image.ImageInfo;
import java.io.File;
import java.io.IOException;

public class ImageTool {
    public static void init(Context context) {
        ImagePipelineConfig config = ImagePipelineConfig.newBuilder((Context)context).setDownsampleEnabled(true).build();
        Fresco.initialize((Context)context);
    }

    public static void removeCache(String url) {
        Fresco.getImagePipeline().evictFromCache(Uri.parse((String)url));
    }

    public static void loadImage(SimpleDraweeView image, String url) {
        image.setImageURI(url);
    }

    public static void fitWidth(final SimpleDraweeView image, String url) {
        BaseControllerListener<ImageInfo> controllerListener = new BaseControllerListener<ImageInfo>(){

            public void onFinalImageSet(String id, @Nullable ImageInfo imageInfo, @Nullable Animatable anim) {
                if (imageInfo != null && image != null) {
                    image.setAspectRatio((float)imageInfo.getWidth() / (float)imageInfo.getHeight());
                }
            }
        };
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setControllerListener((ControllerListener)controllerListener)).setUri(Uri.parse((String)url)).build();
        image.setController((DraweeController)controller);
    }

    public static void setCornersRadius(Context context, SimpleDraweeView image, float radius) {
        GenericDraweeHierarchyBuilder genericDraweeHierarchyBuilder = new GenericDraweeHierarchyBuilder(context.getResources());
        genericDraweeHierarchyBuilder.setRoundingParams(RoundingParams.fromCornersRadius((float)radius));
        image.setHierarchy((DraweeHierarchy)genericDraweeHierarchyBuilder.build());
    }

    public static void setCornersRadius(Context context, SimpleDraweeView image, float[] radius) {
        if (radius.length < 4) {
            return;
        }
        GenericDraweeHierarchyBuilder genericDraweeHierarchyBuilder = new GenericDraweeHierarchyBuilder(context.getResources());
        genericDraweeHierarchyBuilder.setRoundingParams(RoundingParams.fromCornersRadii((float)radius[0], (float)radius[1], (float)radius[2], (float)radius[3]));
        image.setHierarchy((DraweeHierarchy)genericDraweeHierarchyBuilder.build());
    }

    public static void setBorder(SimpleDraweeView image, int color, float width) {
        RoundingParams roundingParams = ((GenericDraweeHierarchy)image.getHierarchy()).getRoundingParams();
        if (roundingParams != null) {
            roundingParams.setBorder(color, width);
            ((GenericDraweeHierarchy)image.getHierarchy()).setRoundingParams(roundingParams);
        }
    }

    public static Bitmap ImageView2Bitmap(ImageView image) {
        if (image == null) {
            return null;
        }
        return ImageTool.Drawable2Bitmap(image.getDrawable());
    }

    public static Bitmap Drawable2Bitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        return ((BitmapDrawable)drawable).getBitmap();
    }

    public static Drawable Bitmap2Drawable(Context context, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        return new BitmapDrawable(context.getResources(), bitmap);
    }

    public static Bitmap restoreImageOrientation(Bitmap selectedBitmap, String imagePath) {
        try {
            int rotate = 0;
            File imageFile = new File(imagePath);
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                }
            }
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotate);
            return Bitmap.createBitmap((Bitmap)selectedBitmap, (int)0, (int)0, (int)selectedBitmap.getWidth(), (int)selectedBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return selectedBitmap;
        }
    }

    public static Bitmap scaleCenterCrop(Bitmap source) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int newWidth = Math.min(sourceWidth, sourceHeight);
        float xScale = (float)newWidth / (float)sourceWidth;
        float yScale = (float)newWidth / (float)sourceHeight;
        float scale = Math.max(xScale, yScale);
        float scaledWidth = scale * (float)sourceWidth;
        float scaledHeight = scale * (float)sourceHeight;
        float left = ((float)newWidth - scaledWidth) / 2.0f;
        float top = ((float)newWidth - scaledHeight) / 2.0f;
        RectF targetRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        Bitmap dest = Bitmap.createBitmap((int)newWidth, (int)newWidth, (Bitmap.Config)source.getConfig());
        Canvas canvas = new Canvas(dest);
        canvas.drawBitmap(source, null, targetRect, null);
        return dest;
    }

    public static long saveImageFromUrl(Context context, String url, Uri imageFileUri, String title, String description) {
        DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
        request.setAllowedNetworkTypes(3).setTitle((CharSequence)title).setDescription((CharSequence)description).setDestinationUri(imageFileUri);
        return downloadManager.enqueue(request);
    }
}

