/*
 * Decompiled with CFR 0.152.
 */
package tr.xip.errorview;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import tr.xip.errorview.R;

public class ErrorView
extends LinearLayout {
    private ImageView imageView;
    private TextView titleView;
    private TextView subtitleView;
    private TextView retryView;
    private RetryListener retryListener;

    public ErrorView(Context context) {
        this(context, null);
    }

    public ErrorView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ev_style);
    }

    public ErrorView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public ErrorView(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs);
        this.init(attrs, defStyle, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs, int defStyle, int defStyleRes) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ErrorView, defStyle, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.error_view_layout, (ViewGroup)this, true);
        this.setOrientation(1);
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayoutTransition(new LayoutTransition());
        }
        this.imageView = (ImageView)this.findViewById(R.id.ev_image);
        this.titleView = (TextView)this.findViewById(R.id.ev_title);
        this.subtitleView = (TextView)this.findViewById(R.id.ev_subtitle);
        this.retryView = (TextView)this.findViewById(R.id.ev_retry);
        try {
            int imageRes = a.getResourceId(R.styleable.ErrorView_ev_image, R.drawable.error_view_cloud);
            int imageTint = a.getColor(R.styleable.ErrorView_ev_imageTint, 0);
            boolean imageVisible = a.getBoolean(R.styleable.ErrorView_ev_imageVisible, true);
            int imageSize = a.getDimensionPixelSize(R.styleable.ErrorView_ev_imageSize, 0);
            String title = a.getString(R.styleable.ErrorView_ev_title);
            int titleColor = a.getColor(R.styleable.ErrorView_ev_titleColor, this.getResources().getColor(R.color.error_view_title));
            boolean titleVisible = a.getBoolean(R.styleable.ErrorView_ev_titleVisible, true);
            String subtitle = a.getString(R.styleable.ErrorView_ev_subtitle);
            int subtitleColor = a.getColor(R.styleable.ErrorView_ev_subtitleColor, this.getResources().getColor(R.color.error_view_subtitle));
            boolean subtitleVisible = a.getBoolean(R.styleable.ErrorView_ev_subtitleVisible, true);
            boolean retryVisible = a.getBoolean(R.styleable.ErrorView_ev_retryVisible, true);
            String retryText = a.getString(R.styleable.ErrorView_ev_retryText);
            int retryBackground = a.getResourceId(R.styleable.ErrorView_ev_retryBackground, R.drawable.error_view_retry_button_background);
            int retryColor = a.getColor(R.styleable.ErrorView_ev_retryColor, this.getResources().getColor(R.color.error_view_retry));
            if (imageRes != 0) {
                this.setImage(imageRes);
            }
            if (imageTint != 0) {
                this.setImageTint(imageTint);
            }
            this.setImageVisible(imageVisible);
            if (imageSize != 0) {
                this.setImageSize(imageSize);
            }
            if (title != null) {
                this.setTitle(title);
            }
            if (subtitle != null) {
                this.setSubtitle(subtitle);
            }
            if (retryText != null) {
                this.retryView.setText((CharSequence)retryText);
            }
            if (!titleVisible) {
                this.titleView.setVisibility(8);
            }
            if (!subtitleVisible) {
                this.subtitleView.setVisibility(8);
            }
            if (!retryVisible) {
                this.retryView.setVisibility(8);
            }
            this.titleView.setTextColor(titleColor);
            this.subtitleView.setTextColor(subtitleColor);
            this.retryView.setTextColor(retryColor);
            this.retryView.setBackgroundResource(retryBackground);
        }
        finally {
            a.recycle();
        }
        this.retryView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ErrorView.this.retryListener != null) {
                    ErrorView.this.retryListener.onRetry();
                }
            }
        });
    }

    public ErrorView setImage(int res) {
        this.imageView.setImageResource(res);
        return this;
    }

    public ErrorView setImage(Drawable drawable2) {
        this.imageView.setImageDrawable(drawable2);
        return this;
    }

    public ErrorView setImage(Bitmap bitmap) {
        this.imageView.setImageBitmap(bitmap);
        return this;
    }

    public ErrorView setImageTint(int color2) {
        this.imageView.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        return this;
    }

    public ErrorView setImageVisible(boolean visible) {
        this.imageView.setVisibility(visible ? 0 : 8);
        return this;
    }

    public ErrorView setImageSize(int width) {
        this.imageView.getLayoutParams().width = width;
        return this;
    }

    public boolean isImageVisible() {
        return this.imageView.getVisibility() == 0;
    }

    public ErrorView setTitle(String text) {
        this.setTitleVisible(text != null);
        this.titleView.setText((CharSequence)text);
        return this;
    }

    public ErrorView setTitle(int res) {
        this.setTitleVisible(true);
        this.titleView.setText(res);
        return this;
    }

    public CharSequence getTitle() {
        return this.titleView.getText();
    }

    public ErrorView setTitleColor(int res) {
        this.titleView.setTextColor(res);
        return this;
    }

    public ErrorView setTitleVisible(boolean visible) {
        this.titleView.setVisibility(visible ? 0 : 8);
        return this;
    }

    public boolean isTitleVisible() {
        return this.titleView.getVisibility() == 0;
    }

    public ErrorView setSubtitle(String subtitle) {
        this.setSubtitleVisible(subtitle != null);
        this.subtitleView.setText((CharSequence)subtitle);
        return this;
    }

    public ErrorView setSubtitle(int res) {
        this.setSubtitleVisible(true);
        this.subtitleView.setText(res);
        return this;
    }

    public CharSequence getSubtitle() {
        return this.subtitleView.getText();
    }

    public ErrorView setSubtitleColor(int res) {
        this.subtitleView.setTextColor(res);
        return this;
    }

    public ErrorView setSubtitleVisible(boolean visible) {
        this.subtitleView.setVisibility(visible ? 0 : 8);
        return this;
    }

    public boolean isSubtitleVisible() {
        return this.subtitleView.getVisibility() == 0;
    }

    public ErrorView setRetryText(String text) {
        this.retryView.setText((CharSequence)text);
        return this;
    }

    public ErrorView setRetryText(int res) {
        this.retryView.setText(res);
        return this;
    }

    public CharSequence getRetryText() {
        return this.retryView.getText();
    }

    public ErrorView setRetryColor(int color2) {
        this.retryView.setTextColor(color2);
        return this;
    }

    public ErrorView setRetryVisible(boolean visible) {
        this.retryView.setVisibility(visible ? 0 : 8);
        return this;
    }

    public boolean isRetryVisible() {
        return this.retryView.getVisibility() == 0;
    }

    public ErrorView setRetryListener(RetryListener listener) {
        this.retryListener = listener;
        return this;
    }

    public static interface RetryListener {
        public void onRetry();
    }
}

