/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiSwapRestClient;
import com.binance.api.client.domain.SwapRemoveType;
import com.binance.api.client.domain.account.Liquidity;
import com.binance.api.client.domain.account.LiquidityOperationRecord;
import com.binance.api.client.domain.account.Pool;
import com.binance.api.client.domain.account.SwapHistory;
import com.binance.api.client.domain.account.SwapQuote;
import com.binance.api.client.domain.account.SwapRecord;
import com.binance.api.client.impl.BinanceApiService;
import com.binance.api.client.impl.BinanceApiServiceGenerator;
import java.util.List;

public class BinanceApiSwapRestClientImpl
implements BinanceApiSwapRestClient {
    private final BinanceApiService binanceApiService;

    public BinanceApiSwapRestClientImpl(String apiKey, String secret) {
        this.binanceApiService = BinanceApiServiceGenerator.createService(BinanceApiService.class, apiKey, secret);
    }

    @Override
    public List<Pool> listAllSwapPools() {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.listAllSwapPools());
    }

    @Override
    public Liquidity getPoolLiquidityInfo(String poolId) {
        long timestamp = System.currentTimeMillis();
        List<Liquidity> liquidities = BinanceApiServiceGenerator.executeSync(this.binanceApiService.getPoolLiquidityInfo(poolId, 60000L, timestamp));
        if (liquidities != null && !liquidities.isEmpty()) {
            return liquidities.get(0);
        }
        return null;
    }

    @Override
    public LiquidityOperationRecord addLiquidity(String poolId, String asset, String quantity) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.addLiquidity(poolId, asset, quantity, 60000L, timestamp));
    }

    @Override
    public LiquidityOperationRecord removeLiquidity(String poolId, SwapRemoveType type, List<String> asset, String shareAmount) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.removeLiquidity(poolId, type, asset, shareAmount, 60000L, timestamp));
    }

    @Override
    public List<LiquidityOperationRecord> getPoolLiquidityOperationRecords(String poolId, Integer limit) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getPoolLiquidityOperationRecords(poolId, limit, 60000L, timestamp));
    }

    @Override
    public LiquidityOperationRecord getLiquidityOperationRecord(String operationId) {
        long timestamp = System.currentTimeMillis();
        List<LiquidityOperationRecord> records = BinanceApiServiceGenerator.executeSync(this.binanceApiService.getLiquidityOperationRecord(operationId, 60000L, timestamp));
        if (records != null && !records.isEmpty()) {
            return records.get(0);
        }
        return null;
    }

    @Override
    public SwapQuote requestQuote(String quoteAsset, String baseAsset, String quoteQty) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.requestQuote(quoteAsset, baseAsset, quoteQty, 60000L, timestamp));
    }

    @Override
    public SwapRecord swap(String quoteAsset, String baseAsset, String quoteQty) {
        long timestamp = System.currentTimeMillis();
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.swap(quoteAsset, baseAsset, quoteQty, 60000L, timestamp));
    }

    @Override
    public SwapHistory getSwapHistory(String swapId) {
        long timestamp = System.currentTimeMillis();
        List<SwapHistory> history = BinanceApiServiceGenerator.executeSync(this.binanceApiService.getSwapHistory(swapId, 60000L, timestamp));
        if (history != null && !history.isEmpty()) {
            return history.get(0);
        }
        return null;
    }
}

