/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiCallback;
import com.binance.api.client.exception.BinanceApiException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class BinanceApiWebSocketListener<T>
extends WebSocketListener {
    private BinanceApiCallback<T> callback;
    private static final ObjectMapper mapper = new ObjectMapper();
    private final ObjectReader objectReader;
    private boolean closing = false;

    public BinanceApiWebSocketListener(BinanceApiCallback<T> callback, Class<T> eventClass) {
        this.callback = callback;
        this.objectReader = mapper.readerFor(eventClass);
    }

    public BinanceApiWebSocketListener(BinanceApiCallback<T> callback, TypeReference<T> eventTypeReference) {
        this.callback = callback;
        this.objectReader = mapper.readerFor(eventTypeReference);
    }

    public void onMessage(WebSocket webSocket, String text) {
        try {
            Object event = this.objectReader.readValue(text);
            this.callback.onResponse(event);
        }
        catch (IOException e) {
            throw new BinanceApiException(e);
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.closing = true;
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        if (!this.closing) {
            this.callback.onFailure(t);
        }
    }
}

