/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.scoreboard.line.lines;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.scoreboard.line.AnimatedLine;

public abstract class FramedLine<O>
implements AnimatedLine<O> {
    @NotNull
    protected final List<String> frames;
    protected int currentFrame = -1;

    public final void addFrame(@NotNull String string) {
        this.frames.add(string);
    }

    @NotNull
    public final String getFrame(int index) {
        return this.frames.get(index);
    }

    public final int getTotalLength() {
        return this.frames.size();
    }

    public final void removeFrame(@NotNull String frame) {
        this.frames.remove(frame);
    }

    public final void setFrame(int index, @NotNull String frame) {
        this.frames.set(index, frame);
    }

    @Override
    @Nullable
    public String getCurrent(@NotNull O observer) {
        if (this.currentFrame <= -1) {
            return null;
        }
        return this.frames.get(this.currentFrame);
    }

    @Override
    @NotNull
    public String getNext(@NotNull O observer) {
        ++this.currentFrame;
        if (this.currentFrame >= this.frames.size()) {
            this.currentFrame = 0;
        }
        return this.frames.get(this.currentFrame);
    }

    @Override
    @NotNull
    public String getPrevious(@NotNull O observer) {
        --this.currentFrame;
        if (this.currentFrame <= -1) {
            this.currentFrame = this.frames.size() - 1;
        }
        return this.frames.get(this.currentFrame);
    }

    protected FramedLine(@NotNull List<String> frames) {
        if (frames == null) {
            throw new NullPointerException("frames is marked non-null but is null");
        }
        this.frames = frames;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(int currentFrame) {
        this.currentFrame = currentFrame;
    }
}

