/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import top.wboost.common.log.entity.Logger;
import top.wboost.common.log.util.LoggerUtil;
import top.wboost.common.util.StringUtil;
import top.wboost.common.utils.web.utils.PropertiesUtil;

@Deprecated
public class PropertiesUtil3
extends PropertyPlaceholderConfigurer {
    private static Logger log = LoggerUtil.getLogger(PropertiesUtil.class);
    private static final String DEFAULT_PROPERTIES = "properties/common-default.properties";
    private static final String DEFAULT_PROPERTIES_SCAN = "properties/*.properties";
    private static final String SYS_PROPERTIES_SCAN = "sys/properties/*.properties";
    private static final String DEFAULT_CONFIG_FILE = "properties/config.properties";
    private static final String DEFAULT_CONFIG_NAME = "sys.properties";
    private static final String PATTERN_COMPILE = "\\$\\{([^\\$]+?)\\}";
    private static final String SPLIT = ":";
    private static String patternComolie = "\\$\\{([^\\$]+?)\\}";
    private static String propertiesFile = "properties/common-default.properties";
    public static Map<String, String> propertyMap = new ConcurrentHashMap<String, String>();
    private PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
    }

    protected Properties mergeProperties() throws IOException {
        Properties result = super.mergeProperties();
        PropertiesUtil3.mergeProperties(result, this.addProperties(DEFAULT_PROPERTIES_SCAN));
        PropertiesUtil3.mergeProperties(result, this.addProperties(SYS_PROPERTIES_SCAN));
        String properties = PropertiesUtil3.getProperty(DEFAULT_CONFIG_NAME, DEFAULT_CONFIG_FILE);
        if (StringUtil.notEmpty((Object)properties).booleanValue()) {
            String[] locations;
            for (String location : locations = StringUtils.commaDelimitedListToStringArray((String)properties)) {
                PropertiesUtil3.mergeProperties(result, this.addProperties(location));
            }
        }
        this.replaceProperties();
        if (log.isInfoEnabled()) {
            log.info(JSONObject.toJSONString(propertyMap));
        }
        Properties retresult = new Properties();
        propertyMap.forEach((key, val) -> retresult.put(key, val));
        return retresult;
    }

    public static Properties mergeProperties(Properties p1, Properties p2) throws IOException {
        p2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(obj1, obj2) -> p1.put(obj1, obj2)));
        return p1;
    }

    private void replaceProperties() {
        int okVal = 0;
        for (String key : propertyMap.keySet()) {
            String value = propertyMap.get(key);
            if (value == null || "".equals(value)) {
                ++okVal;
                continue;
            }
            List list = StringUtil.getPatternMattcherList((String)value, (String)patternComolie, (Integer)0);
            if (list.size() > 0) {
                value = PropertiesUtil3.replace(value);
            } else {
                ++okVal;
            }
            propertyMap.put(key, value);
        }
        if (okVal == propertyMap.size()) {
            return;
        }
        this.replaceProperties();
    }

    private static String replace(String value) {
        List list = StringUtil.getPatternMattcherList((String)value, (String)patternComolie, (Integer)0);
        if (list.size() > 0) {
            log.debug("\u83b7\u5f97\u672a\u8f6c\u5316\u7684${} \u5185\u5bb9\u96c6\u5408 : " + list.toString());
            for (String str : list) {
                String configName = str.substring(2);
                configName = configName.substring(0, configName.length() - 1);
                String pattern = "\\$\\{" + configName + "\\}";
                String realVal = PropertiesUtil3.getPropertiesByConfig(configName);
                if (StringUtil.notEmpty((Object)realVal).booleanValue() && StringUtil.getPatternMattcherList((String)realVal, (String)patternComolie, (Integer)1).size() > 0) continue;
                try {
                    value = value.replaceAll(pattern, realVal);
                }
                catch (Exception o_o) {
                    log.error("replace value: {} , pattern: {}, realVal: {}", new Object[]{value, pattern, realVal});
                    throw o_o;
                }
            }
        }
        return value;
    }

    public static String getProperty(String name) {
        name = PropertiesUtil3.replace(name);
        if (propertyMap != null && propertyMap.containsKey(name)) {
            return propertyMap.get(name);
        }
        return PropertiesUtil3.getProperty(name, propertiesFile);
    }

    public static String getProperty(String name, String path) {
        name = PropertiesUtil3.replace(name);
        Properties properties = PropertiesUtil3.loadProperties(path);
        if (properties != null) {
            return (String)properties.get(name);
        }
        log.warn("name {},path: {} properties is undefined", (Object)name, (Object)path);
        return null;
    }

    public static String getPropertyOrDefault(String name, String defaultVal) {
        String value = PropertiesUtil3.getProperty(name);
        return value != null ? value : defaultVal;
    }

    public static String getPropertyOrDefault(String name, String path, String defaultVal) {
        String value = PropertiesUtil3.getProperty(name, path);
        return value != null ? value : defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties loadProperties(String path) {
        Properties properties;
        InputStream in = null;
        try {
            in = PropertiesUtil.class.getClassLoader().getResourceAsStream(path);
            Properties prop = new Properties();
            prop.load(new InputStreamReader(in, "UTF-8"));
            properties = prop;
        }
        catch (Exception e) {
            try {
                log.warn("loadProperties path:{} , {}", (Object)path, (Object)e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return null;
        }
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }

    public static Map<String, String> getPropertiesByPrefix(String prefix) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            retMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }

    public Properties addProperties(Resource ... resources) {
        Properties properties = new Properties();
        try {
            for (Resource resource : resources) {
                InputStream stream = resource.getInputStream();
                properties.load(stream);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    propertyMap.put(entry.getKey().toString(), entry.getValue().toString());
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        this.replaceProperties();
        return properties;
    }

    private Properties addProperties(String location) {
        try {
            Resource[] resources = this.resolver.getResources(location);
            return this.addProperties(resources);
        }
        catch (Exception e) {
            log.warn("addProperties:{} error,exteption is {}", (Object)location, (Object)e.getLocalizedMessage());
            return new Properties();
        }
    }

    private static String getPropertiesByConfig(String propertiesKey) {
        String settingKey = propertiesKey;
        String defaultKey = null;
        if (settingKey.contains(SPLIT)) {
            defaultKey = settingKey.substring(settingKey.indexOf(SPLIT) + 1);
            settingKey = settingKey.substring(0, settingKey.indexOf(SPLIT));
        }
        return PropertiesUtil3.getPropertyOrDefault(settingKey, defaultKey);
    }
}

