/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import top.wboost.common.log.entity.Logger;
import top.wboost.common.log.util.LoggerUtil;
import top.wboost.common.utils.web.utils.HibernateUtil;
import top.wboost.common.utils.web.utils.JSONConfig;

public class JSONObjectUtil {
    public static SerializeConfig serializeConfig = new SerializeConfig();
    private static Logger log = LoggerUtil.getLogger(JSONObjectUtil.class);
    public static PropertyFilter defaultSerializeFilter;

    public static PropertyFilter buildPropertyFilter(String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return defaultSerializeFilter;
        }
        HashSet fieldNameList = new HashSet();
        Collections.addAll(fieldNameList, fieldNames);
        return (object, name, value) -> {
            if (fieldNameList.contains(name) || value == null) {
                return false;
            }
            return HibernateUtil.wasInitialized(value);
        };
    }

    public static <T> List<T> parseArray(String parse, Class<T> clazz) {
        log.debug("parseArray:" + parse);
        JSONArray parseList = JSONObject.parseArray((String)parse);
        ArrayList returnList = new ArrayList();
        parseList.forEach(parseObj -> {
            Object parseEntity = JSONObject.parseObject((String)parseObj.toString(), (Class)clazz);
            returnList.add(parseEntity);
        });
        return returnList;
    }

    public static String toJSONString(Object obj, String ... filterName) {
        return JSONObjectUtil.toJSONString(obj, null, filterName);
    }

    public static String toJSONString(Object obj, JSONConfig config, String ... filterName) {
        ArrayList<SerializerFeature> serializerFeatureList = new ArrayList<SerializerFeature>();
        if (config != null && config.isDisableCircularReferenceDetect()) {
            serializerFeatureList.add(SerializerFeature.DisableCircularReferenceDetect);
        }
        return JSONObject.toJSONString((Object)obj, (SerializeConfig)serializeConfig, (SerializeFilter)JSONObjectUtil.buildPropertyFilter(filterName), (SerializerFeature[])serializerFeatureList.toArray(new SerializerFeature[serializerFeatureList.size()]));
    }

    static {
        SimpleDateFormatSerializer dateFormat = new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss");
        serializeConfig.put(Date.class, (ObjectSerializer)dateFormat);
        serializeConfig.put(Timestamp.class, (ObjectSerializer)dateFormat);
        defaultSerializeFilter = (object, name, value) -> {
            if (value == null) {
                return false;
            }
            return HibernateUtil.wasInitialized(value);
        };
    }
}

