/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import top.wboost.common.base.enums.CharsetEnum;
import top.wboost.common.exception.BusinessException;
import top.wboost.common.log.entity.Logger;
import top.wboost.common.log.util.LoggerUtil;
import top.wboost.common.util.StringUtil;
import top.wboost.common.utils.web.core.ConfigProperties;

public class PropertiesUtil {
    private static Logger log = LoggerUtil.getLogger(PropertiesUtil.class);
    private static PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();

    public static String getProperty(String name) {
        return PropertiesUtil.getPropertyOrDefault(name, null, null);
    }

    public static String getProperty(String name, String path) {
        return PropertiesUtil.getPropertyOrDefault(name, path, null);
    }

    public static String getPropertyOrDefault(String name, String defaultVal) {
        return PropertiesUtil.getPropertyOrDefault(name, null, defaultVal);
    }

    public static String getPropertyOrDefault(String name, String path, String defaultVal) {
        String val;
        block11: {
            val = null;
            try {
                if (!StringUtil.notEmpty((Object)path).booleanValue()) {
                    if (ConfigProperties.resolver != null) {
                        val = ConfigProperties.resolver.resolveStringValue("${" + name + "}");
                        if (val != null) {
                            val = new String(val.getBytes(CharsetEnum.ISO_8859_1.getName()), CharsetEnum.UTF_8.getCharset());
                        }
                    } else {
                        val = ConfigProperties.localenv.getProperty(name, defaultVal);
                    }
                    if (("${" + name + "}").equals(val)) {
                        val = null;
                    }
                    break block11;
                }
                try {
                    EncodedResource[] resources;
                    for (EncodedResource resource : resources = PropertiesUtil.loadResources(path)) {
                        Properties properties = PropertiesLoaderUtils.loadProperties((EncodedResource)resource);
                        Object obj = properties.get(name);
                        if (obj == null) continue;
                        val = obj.toString();
                        break;
                    }
                }
                catch (IOException e) {
                    if (log.isWarnEnabled()) {
                        log.warn(e.getLocalizedMessage());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val == null ? defaultVal : val;
    }

    public static Properties loadProperties(String location) {
        EncodedResource[] resources = PropertiesUtil.loadResources(location);
        Properties prop = new Properties();
        try {
            for (EncodedResource resource : resources) {
                prop.putAll((Map<?, ?>)PropertiesLoaderUtils.loadProperties((EncodedResource)resource));
            }
            return prop;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Properties();
        }
    }

    public static Map<String, Object> getPropertiesByPrefix(String prefix) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : PropertiesUtil.getAllProperties().entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            retMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }

    public static Map<String, Object> getAllProperties() {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        for (PropertySource s : ConfigProperties.localenv.getPropertySources()) {
            if (s.getSource() instanceof Map) {
                retMap.putAll((Map)s.getSource());
                continue;
            }
            if (!(s instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource source = (EnumerablePropertySource)s;
            String[] nameArray = source.getPropertyNames();
            Arrays.asList(nameArray).forEach(name -> retMap.put((String)name, s.getProperty(name)));
        }
        return retMap;
    }

    private static EncodedResource[] loadResources(String location) {
        try {
            Resource[] resources = resourceResolver.getResources(location);
            EncodedResource[] encodeResources = new EncodedResource[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                encodeResources[i] = new EncodedResource(resource, CharsetEnum.UTF_8.getCharset());
            }
            return encodeResources;
        }
        catch (Exception e) {
            log.error("loadResource error", (Throwable)e);
            throw new BusinessException("loadResource error");
        }
    }

    public static Object getPropertiesObject(String name) {
        return PropertiesUtil.getAllProperties().get(name);
    }
}

