/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.controller;

import top.tangyh.basic.base.R;
import top.tangyh.basic.base.service.SuperService;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.exception.BizException;
import top.tangyh.basic.exception.code.BaseExceptionCode;

public interface BaseController<Entity> {
    public Class<Entity> getEntityClass();

    public SuperService<Entity> getBaseService();

    default public <T> R<T> success(T data) {
        return R.success(data);
    }

    default public R<Boolean> success() {
        return R.success();
    }

    default public <T> R<T> fail(String msg) {
        return R.fail((String)msg);
    }

    default public <T> R<T> fail(String msg, Object ... args) {
        return R.fail((String)msg, (Object[])args);
    }

    default public <T> R<T> fail(int code, String msg) {
        return R.fail((int)code, (String)msg);
    }

    default public <T> R<T> fail(BaseExceptionCode exceptionCode) {
        return R.fail((BaseExceptionCode)exceptionCode);
    }

    default public <T> R<T> fail(BizException exception) {
        return R.fail((BizException)exception);
    }

    default public <T> R<T> fail(Throwable throwable) {
        return R.fail((Throwable)throwable);
    }

    default public <T> R<T> validFail(String msg) {
        return R.validFail((String)msg);
    }

    default public <T> R<T> validFail(String msg, Object ... args) {
        return R.validFail((String)msg, (Object[])args);
    }

    default public <T> R<T> validFail(BaseExceptionCode exceptionCode) {
        return R.validFail((BaseExceptionCode)exceptionCode);
    }

    default public Long getUserId() {
        return ContextUtil.getUserId();
    }

    default public String getTenant() {
        return ContextUtil.getTenant();
    }

    default public String getAccount() {
        return ContextUtil.getAccount();
    }

    default public String getName() {
        return ContextUtil.getName();
    }
}

