/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.database.plugins;

import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Method;
import lombok.Generated;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import top.tangyh.basic.annotation.database.TenantLine;
import top.tangyh.basic.database.plugins.TenantLineHelper;

public class TenantLineAnnotationRegister
implements EnvironmentCapable,
BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantLineAnnotationRegister.class);
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private Environment environment;
    private ResourcePatternResolver resourcePatternResolver;

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)this.getEnvironment().resolveRequiredPlaceholders(basePackage));
    }

    public final Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        MapperScan mapperScan = (MapperScan)AnnotationUtils.findAnnotation(bean.getClass(), MapperScan.class);
        if (mapperScan == null) {
            return bean;
        }
        Object[] basePackages = mapperScan.basePackages();
        if (ArrayUtil.isEmpty((Object[])basePackages)) {
            return bean;
        }
        try {
            ResourcePatternResolver resourcePatternResolver = this.getResourcePatternResolver();
            SimpleMetadataReaderFactory metadata = new SimpleMetadataReaderFactory();
            for (Object basePackage : basePackages) {
                Resource[] resources;
                String packageSearchPath = "classpath*:" + this.resolveBasePackage((String)basePackage) + "/**/*.class";
                for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                    Method[] declaredMethods;
                    TenantLine tenantLineClazz;
                    MetadataReader metadataReader = metadata.getMetadataReader(resource);
                    String className = metadataReader.getClassMetadata().getClassName();
                    Class<?> clazz = Class.forName(className);
                    if (clazz == null || (tenantLineClazz = clazz.getAnnotation(TenantLine.class)) == null) continue;
                    TenantLineHelper.CACHE.put(className, tenantLineClazz.value());
                    for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                        TenantLine tenantLineField = method.getAnnotation(TenantLine.class);
                        if (tenantLineField == null) continue;
                        TenantLineHelper.CACHE.put(className + "." + method.getName(), tenantLineField.value());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("======================\u6ce8\u610f\uff1a\u626b\u63cf\u3010{}\u3011\u62a5\u9519", (Object)basePackages, (Object)e);
        }
        return bean;
    }

    private ResourcePatternResolver getResourcePatternResolver() {
        if (this.resourcePatternResolver == null) {
            this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
        }
        return this.resourcePatternResolver;
    }

    @Generated
    public TenantLineAnnotationRegister() {
    }
}

