/*
 * Decompiled with CFR 0.152.
 */
package top.lrshuai.encryption;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SHAUtil {
    public static String jdkSHA1(String key) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(key.getBytes());
        return Hex.encodeHexString((byte[])md.digest());
    }

    public static String bcSHA1(String key) throws Exception {
        SHA1Digest digest = new SHA1Digest();
        digest.update(key.getBytes(), 0, key.getBytes().length);
        byte[] shabtyte = new byte[digest.getDigestSize()];
        digest.doFinal(shabtyte, 0);
        return org.bouncycastle.util.encoders.Hex.toHexString((byte[])shabtyte);
    }

    public static String bcSHA224(String key) throws Exception {
        SHA224Digest digest = new SHA224Digest();
        digest.update(key.getBytes(), 0, key.getBytes().length);
        byte[] shabtyte = new byte[digest.getDigestSize()];
        digest.doFinal(shabtyte, 0);
        return org.bouncycastle.util.encoders.Hex.toHexString((byte[])shabtyte);
    }

    public static String bcSHA224Two(String key) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        MessageDigest md = MessageDigest.getInstance("SHA-224");
        md.update(key.getBytes());
        return Hex.encodeHexString((byte[])md.digest());
    }

    public static String ccSHA1(String key) {
        return DigestUtils.sha1Hex((byte[])key.getBytes());
    }

    public static String ccSHA2(String key) {
        return DigestUtils.shaHex((String)key);
    }

    public static void main(String[] args) throws Exception {
        String key = "www.lrshuai.top";
        System.out.println(SHAUtil.jdkSHA1(key));
        System.out.println(SHAUtil.bcSHA1(key));
        System.out.println(SHAUtil.bcSHA224(key));
        System.out.println(SHAUtil.bcSHA224Two(key));
    }
}

