/*
 * Decompiled with CFR 0.152.
 */
package top.javatool.canal.client.spring.boot.autoconfigure;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import top.javatool.canal.client.client.KafkaCanalClient;
import top.javatool.canal.client.factory.IModelFactory;
import top.javatool.canal.client.factory.MapColumnModelFactory;
import top.javatool.canal.client.handler.EntryHandler;
import top.javatool.canal.client.handler.MessageHandler;
import top.javatool.canal.client.handler.RowDataHandler;
import top.javatool.canal.client.handler.impl.AsyncFlatMessageHandlerImpl;
import top.javatool.canal.client.handler.impl.MapRowDataHandlerImpl;
import top.javatool.canal.client.handler.impl.SyncFlatMessageHandlerImpl;
import top.javatool.canal.client.spring.boot.autoconfigure.ThreadPoolAutoConfiguration;
import top.javatool.canal.client.spring.boot.properties.CanalKafkaProperties;

@Configuration
@EnableConfigurationProperties(value={CanalKafkaProperties.class})
@ConditionalOnBean(value={EntryHandler.class})
@ConditionalOnProperty(value={"canal.mode"}, havingValue="kafka")
@Import(value={ThreadPoolAutoConfiguration.class})
public class KafkaClientAutoConfiguration {
    private CanalKafkaProperties canalKafkaProperties;

    public KafkaClientAutoConfiguration(CanalKafkaProperties canalKafkaProperties) {
        this.canalKafkaProperties = canalKafkaProperties;
    }

    @Bean
    public RowDataHandler<List<Map<String, String>>> rowDataHandler() {
        return new MapRowDataHandlerImpl((IModelFactory)new MapColumnModelFactory());
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="true")
    public MessageHandler messageHandler(RowDataHandler<List<Map<String, String>>> rowDataHandler, List<EntryHandler> entryHandlers, ExecutorService executorService) {
        return new AsyncFlatMessageHandlerImpl(entryHandlers, rowDataHandler, executorService);
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="false")
    public MessageHandler messageHandler(RowDataHandler<List<Map<String, String>>> rowDataHandler, List<EntryHandler> entryHandlers) {
        return new SyncFlatMessageHandlerImpl(entryHandlers, rowDataHandler);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public KafkaCanalClient zookeeperClusterCanalClient(MessageHandler messageHandler) {
        return KafkaCanalClient.builder().servers(this.canalKafkaProperties.getServers()).groupId(this.canalKafkaProperties.getGroupId()).topic(this.canalKafkaProperties.getTopic()).messageHandler(messageHandler).batchSize(this.canalKafkaProperties.getBatchSize()).filter(this.canalKafkaProperties.getFilter()).timeout(this.canalKafkaProperties.getTimeout()).unit(this.canalKafkaProperties.getUnit()).build();
    }
}

