/*
 * Decompiled with CFR 0.152.
 */
package top.javatool.canal.client.spring.boot.autoconfigure;

import com.alibaba.otter.canal.protocol.CanalEntry;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import top.javatool.canal.client.client.ClusterCanalClient;
import top.javatool.canal.client.factory.EntryColumnModelFactory;
import top.javatool.canal.client.factory.IModelFactory;
import top.javatool.canal.client.handler.EntryHandler;
import top.javatool.canal.client.handler.MessageHandler;
import top.javatool.canal.client.handler.RowDataHandler;
import top.javatool.canal.client.handler.impl.AsyncMessageHandlerImpl;
import top.javatool.canal.client.handler.impl.RowDataHandlerImpl;
import top.javatool.canal.client.handler.impl.SyncMessageHandlerImpl;
import top.javatool.canal.client.spring.boot.autoconfigure.ThreadPoolAutoConfiguration;
import top.javatool.canal.client.spring.boot.properties.CanalClusterProperties;

@Configuration
@EnableConfigurationProperties(value={CanalClusterProperties.class})
@ConditionalOnBean(value={EntryHandler.class})
@ConditionalOnProperty(value={"canal.mode"}, havingValue="cluster")
@Import(value={ThreadPoolAutoConfiguration.class})
public class ClusterClientAutoConfiguration {
    private CanalClusterProperties canalClusterProperties;

    public ClusterClientAutoConfiguration(CanalClusterProperties canalClusterProperties) {
        this.canalClusterProperties = canalClusterProperties;
    }

    @Bean
    public RowDataHandler<CanalEntry.RowData> rowDataHandler() {
        return new RowDataHandlerImpl((IModelFactory)new EntryColumnModelFactory());
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="true", matchIfMissing=true)
    public MessageHandler messageHandler(RowDataHandler<CanalEntry.RowData> rowDataHandler, List<EntryHandler> entryHandlers, ExecutorService executorService) {
        return new AsyncMessageHandlerImpl(entryHandlers, rowDataHandler, executorService);
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="false")
    public MessageHandler messageHandler(RowDataHandler<CanalEntry.RowData> rowDataHandler, List<EntryHandler> entryHandlers) {
        return new SyncMessageHandlerImpl(entryHandlers, rowDataHandler);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public ClusterCanalClient simpleCanalClient(MessageHandler messageHandler) {
        return ClusterCanalClient.Builder.builder().canalServers(this.canalClusterProperties.getCanalServers()).destination(this.canalClusterProperties.getDestination()).userName(this.canalClusterProperties.getUserName()).messageHandler(messageHandler).password(this.canalClusterProperties.getPassword()).batchSize(this.canalClusterProperties.getBatchSize()).filter(this.canalClusterProperties.getFilter()).timeout(this.canalClusterProperties.getTimeout()).unit(this.canalClusterProperties.getUnit()).build();
    }
}

