/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.util.system;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.Window;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Ltop/heue/utils/base/util/system/BarUtil;", "", "()V", "getStatusBarHeight", "", "context", "Landroid/content/Context;", "setCommonUI", "", "activity", "Landroid/app/Activity;", "dark", "setFlymeUI", "setMiuiUI", "setMode", "", "base_release"})
public final class BarUtil {
    @NotNull
    public static final BarUtil INSTANCE = new BarUtil();

    private BarUtil() {
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    public final void setMode(@NotNull Activity activity2, boolean dark) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        if (Build.VERSION.SDK_INT >= 30) {
            WindowInsetsController controller = activity2.getWindow().getDecorView().getWindowInsetsController();
            if (dark) {
                WindowInsetsController windowInsetsController = controller;
                if (windowInsetsController != null) {
                    windowInsetsController.setSystemBarsAppearance(24, 24);
                }
            } else {
                WindowInsetsController windowInsetsController = controller;
                if (windowInsetsController != null) {
                    windowInsetsController.setSystemBarsAppearance(0, 24);
                }
            }
        } else if (Build.VERSION.SDK_INT >= 23 && !this.setMiuiUI(activity2, dark) && !this.setFlymeUI(activity2, dark)) {
            this.setCommonUI(activity2, dark);
        }
    }

    private final boolean setCommonUI(Activity activity2, boolean dark) {
        boolean result = false;
        if (Build.VERSION.SDK_INT >= 23) {
            if (dark) {
                activity2.getWindow().getDecorView().setSystemUiVisibility(8192);
            } else {
                activity2.getWindow().getDecorView().setSystemUiVisibility(0);
            }
            result = true;
        }
        return result;
    }

    private final boolean setFlymeUI(Activity activity2, boolean dark) {
        boolean result = false;
        try {
            Window window = activity2.getWindow();
            WindowManager.LayoutParams lp = window.getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = dark ? value | bit : value & ~bit;
            meizuFlags.setInt(lp, value);
            window.setAttributes(lp);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @SuppressLint(value={"PrivateApi"})
    private final boolean setMiuiUI(Activity activity2, boolean dark) {
        boolean result = false;
        try {
            Window window = activity2.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            Window window2 = window;
            Class<?> clazz = activity2.getWindow().getClass();
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"layoutParams.getField(\"E\u2026AG_STATUS_BAR_DARK_MODE\")");
            Field field2 = field;
            int darkModeFlag = field2.getInt(layoutParams);
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Method method = clazz.getMethod("setExtraFlags", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"clazz.getMethod(\n       \u2026imitiveType\n            )");
            Method extraFlagField = method;
            if (dark) {
                Object[] objectArray = new Object[]{darkModeFlag, darkModeFlag};
                extraFlagField.invoke((Object)window2, objectArray);
            } else {
                Object[] objectArray = new Object[]{0, darkModeFlag};
                extraFlagField.invoke((Object)window2, objectArray);
            }
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

