/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AdapterHelper<T>
extends RecyclerView.Adapter<ViewHolder> {
    public List<T> itemData;
    private final int defaultLayout;
    private final int brId;

    public AdapterHelper(List<T> itemData, int defaultLayout, int brId) {
        this.itemData = itemData;
        this.defaultLayout = defaultLayout;
        this.brId = brId;
    }

    public int getItemLayout(T itemData) {
        return this.defaultLayout;
    }

    public int getItemViewType(int position) {
        return this.getItemLayout(this.itemData.get(position));
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)parent.getContext()), (int)viewType, (ViewGroup)parent, (boolean)false);
        return new ViewHolder(binding);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.binding.setVariable(this.brId, this.itemData.get(position));
        holder.binding.executePendingBindings();
    }

    public int getItemCount() {
        return this.itemData == null ? 0 : this.itemData.size();
    }

    public void addItem(int position, T item) {
        this.itemData.add(position, item);
        this.notifyItemChanged(position);
    }

    public void addItem(T item) {
        this.itemData.add(item);
        this.notifyItemChanged(this.itemData.size() - 1);
    }

    public void changeItem(int position, T item) {
        this.itemData.set(position, item);
        this.notifyItemChanged(position);
    }

    public void changeItem(T item) {
        int pos = this.itemData.indexOf(item);
        this.itemData.set(pos, item);
        this.notifyItemChanged(pos);
    }

    public void removeItem(int position) {
        this.itemData.remove(position);
        this.notifyItemRemoved(position);
    }

    public void removeItem(T item) {
        int pos = this.itemData.indexOf(item);
        this.itemData.remove(pos);
        this.notifyItemRemoved(pos);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void changeAllItem(List<T> itemData) {
        this.itemData = itemData;
        this.notifyDataSetChanged();
    }

    public void changeRangeItem(List<T> itemData, int positionStart, int itemCount) {
        this.itemData = itemData;
        this.notifyItemRangeChanged(positionStart, itemCount);
    }

    public void insertRangeItem(List<T> itemData, int positionStart, int itemCount) {
        this.itemData = itemData;
        this.notifyItemRangeInserted(positionStart, itemCount);
    }

    public void removeRangeItem(List<T> itemData, int positionStart, int itemCount) {
        this.itemData = itemData;
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        ViewDataBinding binding;

        ViewHolder(ViewDataBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }
    }
}

