/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.osgi;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.InjectableValues;

public class OsgiInjectableValues
extends InjectableValues {
    private final BundleContext bundleContext;

    public OsgiInjectableValues(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public InjectableValues snapshot() {
        return this;
    }

    public Object findInjectableValue(DeserializationContext ctxt, Object valueId, BeanProperty forProperty, Object beanInstance, Boolean optional, Boolean useInput) {
        return this.findService(OsgiInjectableValues.serviceType(forProperty), this.serviceFilter(valueId));
    }

    private Object findService(String type, String filter) {
        try {
            ServiceReference[] srs = this.bundleContext.getServiceReferences(type, filter);
            if (srs == null || srs.length == 0) {
                return null;
            }
            return this.bundleContext.getService(srs[0]);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static String serviceType(BeanProperty forProperty) {
        return forProperty.getType().toCanonical();
    }

    private String serviceFilter(Object valueId) {
        try {
            return this.bundleContext.createFilter(valueId.toString()).toString();
        }
        catch (InvalidSyntaxException e) {
            return null;
        }
    }
}

