/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.deser;

import java.util.function.ObjIntConsumer;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;

final class SettableIntProperty
extends OptimizedSettableBeanProperty<SettableIntProperty> {
    private static final long serialVersionUID = 1L;
    private ObjIntConsumer<Object> _optimizedSetter;

    public SettableIntProperty(SettableBeanProperty src, ObjIntConsumer<Object> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableIntProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        if (!p.isExpectedNumberIntToken()) {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        int v = p.getIntValue();
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, v, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        if (p.isExpectedNumberIntToken()) {
            return this.setAndReturn(ctxt, instance, p.getIntValue());
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object value) {
        int v = ((Number)value).intValue();
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, v, e);
        }
    }
}

