/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import java.util.function.Supplier;
import tools.jackson.core.Version;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.util.NativeImageUtil;
import tools.jackson.module.blackbird.CrossLoaderAccess;
import tools.jackson.module.blackbird.PackageVersion;
import tools.jackson.module.blackbird.deser.BBDeserializerModifier;
import tools.jackson.module.blackbird.ser.BBSerializerModifier;

public class BlackbirdModule
extends JacksonModule {
    private Function<Class<?>, MethodHandles.Lookup> _lookups;

    public BlackbirdModule() {
        this(MethodHandles::lookup);
    }

    public BlackbirdModule(Function<Class<?>, MethodHandles.Lookup> lookups) {
        this._lookups = lookups;
    }

    public BlackbirdModule(Supplier<MethodHandles.Lookup> lookup) {
        this((Class<?> c) -> {
            String className = c.getName();
            return className.startsWith("java.") || className.startsWith("sun.misc.") ? null : (MethodHandles.Lookup)lookup.get();
        });
    }

    public void setupModule(JacksonModule.SetupContext context) {
        if (NativeImageUtil.isInNativeImage()) {
            return;
        }
        CrossLoaderAccess openSesame = new CrossLoaderAccess();
        context.addDeserializerModifier((ValueDeserializerModifier)new BBDeserializerModifier(this._lookups, openSesame));
        context.addSerializerModifier((ValueSerializerModifier)new BBSerializerModifier(this._lookups, openSesame));
    }

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }
}

