/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.ser;

import java.util.logging.Level;
import java.util.logging.Logger;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.module.afterburner.ser.BeanPropertyAccessor;
import tools.jackson.module.afterburner.ser.SerializerUtil;

abstract class OptimizedBeanPropertyWriter<T extends OptimizedBeanPropertyWriter<T>>
extends BeanPropertyWriter {
    protected final BeanPropertyAccessor _propertyAccessor;
    protected final SerializableString _fastName;
    protected final int _propertyIndex;
    protected final BeanPropertyWriter fallbackWriter;
    protected boolean broken = false;

    protected OptimizedBeanPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor propertyAccessor, int propertyIndex, ValueSerializer<Object> ser) {
        super(src);
        this.fallbackWriter = this.unwrapFallbackWriter(src);
        this._serializer = ser != null ? ser : src.getSerializer();
        this._propertyAccessor = propertyAccessor;
        this._propertyIndex = propertyIndex;
        this._fastName = src.getSerializedName();
    }

    protected OptimizedBeanPropertyWriter(OptimizedBeanPropertyWriter<?> base, PropertyName name) {
        super(base, name);
        this.fallbackWriter = base.fallbackWriter;
        this._serializer = base._serializer;
        this._propertyAccessor = base._propertyAccessor;
        this._propertyIndex = base._propertyIndex;
        this._fastName = this.getSerializedName();
    }

    private BeanPropertyWriter unwrapFallbackWriter(BeanPropertyWriter srcIn) {
        while (srcIn instanceof OptimizedBeanPropertyWriter) {
            srcIn = ((OptimizedBeanPropertyWriter)srcIn).fallbackWriter;
        }
        return srcIn;
    }

    protected abstract BeanPropertyWriter _new(PropertyName var1);

    public void assignTypeSerializer(TypeSerializer typeSer) {
        super.assignTypeSerializer(typeSer);
        if (this.fallbackWriter != null) {
            this.fallbackWriter.assignTypeSerializer(typeSer);
        }
    }

    public void assignSerializer(ValueSerializer<Object> ser) {
        super.assignSerializer(ser);
        if (this.fallbackWriter != null) {
            this.fallbackWriter.assignSerializer(ser);
        }
        if (!SerializerUtil.isDefaultSerializer(ser)) {
            this.broken = true;
        }
    }

    public void assignNullSerializer(ValueSerializer<Object> nullSer) {
        super.assignNullSerializer(nullSer);
        if (this.fallbackWriter != null) {
            this.fallbackWriter.assignNullSerializer(nullSer);
        }
    }

    public abstract T withAccessor(BeanPropertyAccessor var1);

    public abstract BeanPropertyWriter withSerializer(ValueSerializer<Object> var1);

    public abstract void serializeAsProperty(Object var1, JsonGenerator var2, SerializationContext var3) throws Exception;

    public abstract void serializeAsElement(Object var1, JsonGenerator var2, SerializationContext var3) throws Exception;

    protected synchronized void _handleProblem(Object bean, JsonGenerator g, SerializationContext ctxt, Throwable t, boolean element) throws Exception {
        if (t instanceof IllegalAccessError || t instanceof SecurityException) {
            this._reportProblem(bean, t);
            if (element) {
                this.fallbackWriter.serializeAsElement(bean, g, ctxt);
            } else {
                this.fallbackWriter.serializeAsProperty(bean, g, ctxt);
            }
            return;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw (Exception)t;
    }

    protected void _reportProblem(Object bean, Throwable e) {
        this.broken = true;
        String msg = String.format("Disabling Afterburner serialization for %s (field #%d; mutator %s), due to access error (type %s, message=%s)%n", bean.getClass(), this._propertyIndex, ((Object)((Object)this)).getClass().getName(), e.getClass().getName(), e.getMessage());
        Logger.getLogger(OptimizedBeanPropertyWriter.class.getName()).log(Level.WARNING, msg, e);
    }
}

