/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.deser;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.afterburner.deser.BeanPropertyMutator;
import tools.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;

public final class SettableBooleanMethodProperty
extends OptimizedSettableBeanProperty<SettableBooleanMethodProperty> {
    private static final long serialVersionUID = 1L;

    public SettableBooleanMethodProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableBooleanMethodProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableBooleanMethodProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        boolean b;
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            b = true;
        } else if (t == JsonToken.VALUE_FALSE) {
            b = false;
        } else {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        try {
            this._propertyMutator.booleanSetter(ctxt, bean, this._optimizedIndex, b);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, b, e);
        }
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object value) {
        boolean b = (Boolean)value;
        try {
            this._propertyMutator.booleanSetter(ctxt, bean, this._optimizedIndex, b);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, b, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return this.setAndReturn(ctxt, instance, Boolean.TRUE);
        }
        if (t == JsonToken.VALUE_FALSE) {
            return this.setAndReturn(ctxt, instance, Boolean.FALSE);
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }
}

