/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.deser;

import java.util.logging.Level;
import java.util.logging.Logger;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.NullValueProvider;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.impl.NullsConstantProvider;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.module.afterburner.deser.BeanPropertyMutator;
import tools.jackson.module.afterburner.deser.DelegatingPropertyMutator;
import tools.jackson.module.afterburner.deser.SuperSonicBeanDeserializer;

abstract class OptimizedSettableBeanProperty<T extends OptimizedSettableBeanProperty<T>>
extends SettableBeanProperty.Delegating {
    private static final long serialVersionUID = 1L;
    protected BeanPropertyMutator _propertyMutator;
    protected final int _optimizedIndex;
    protected final boolean _skipNulls;
    private volatile boolean broken = false;

    protected OptimizedSettableBeanProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src);
        this._propertyMutator = mutator;
        this._optimizedIndex = index;
        this._skipNulls = NullsConstantProvider.isSkipper((NullValueProvider)this._nullProvider);
    }

    public final SettableBeanProperty withValueDeserializer(ValueDeserializer<?> deser) {
        SettableBeanProperty newDelegate = this.delegate.withValueDeserializer(deser);
        if (newDelegate == this.delegate) {
            return this;
        }
        if (!this._isDefaultDeserializer(deser)) {
            return newDelegate;
        }
        return this.withDelegate(newDelegate);
    }

    protected abstract SettableBeanProperty withDelegate(SettableBeanProperty var1);

    public abstract SettableBeanProperty withMutator(BeanPropertyMutator var1);

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws JacksonException;

    public abstract void set(DeserializationContext var1, Object var2, Object var3);

    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws JacksonException;

    public Object setAndReturn(DeserializationContext ctxt, Object instance, Object value) {
        return this.delegate.setAndReturn(ctxt, instance, value);
    }

    public int getOptimizedIndex() {
        return this._optimizedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _reportProblem(DeserializationContext ctxt, Object bean, Object value, Throwable e) throws JacksonException {
        if (e instanceof IllegalAccessError || e instanceof SecurityException) {
            OptimizedSettableBeanProperty optimizedSettableBeanProperty = this;
            synchronized (optimizedSettableBeanProperty) {
                if (!this.broken) {
                    this.broken = true;
                    String msg = String.format("Disabling Afterburner deserialization for %s (field #%d; mutator %s), due to access error (type %s, message=%s)%n", bean.getClass(), this._optimizedIndex, ((Object)((Object)this)).getClass().getName(), e.getClass().getName(), e.getMessage());
                    Logger.getLogger(BeanPropertyMutator.class.getName()).log(Level.WARNING, msg, e);
                    this._propertyMutator = new DelegatingPropertyMutator(this.delegate);
                }
            }
            this.delegate.set(ctxt, bean, value);
            return;
        }
        if (e instanceof JacksonException) {
            throw (JacksonException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    protected boolean _isDefaultDeserializer(ValueDeserializer<?> deser) {
        return deser == null || deser instanceof SuperSonicBeanDeserializer || ClassUtil.isJacksonStdImpl(deser);
    }
}

