/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.deser;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.std.StdValueInstantiator;
import tools.jackson.databind.introspect.AnnotatedWithParams;
import tools.jackson.module.afterburner.deser.OptimizedValueInstantiator;
import tools.jackson.module.afterburner.util.ClassName;
import tools.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import tools.jackson.module.afterburner.util.MyClassLoader;
import tools.jackson.module.afterburner.util.bytebuddy.ConstructorCallStackManipulation;
import tools.jackson.module.afterburner.util.bytebuddy.SimpleExceptionHandler;

public class CreatorOptimizer
extends DynamicPropertyAccessorBase {
    protected final Class<?> _valueClass;
    protected final MyClassLoader _classLoader;
    protected final StdValueInstantiator _originalInstantiator;

    public CreatorOptimizer(Class<?> valueClass, MyClassLoader classLoader, StdValueInstantiator orig) {
        this._valueClass = valueClass;
        this._classLoader = classLoader;
        this._originalInstantiator = orig;
    }

    public ValueInstantiator createOptimized() {
        if (this._originalInstantiator.canCreateFromObjectWith() || this._originalInstantiator.canCreateUsingDelegate()) {
            return null;
        }
        AnnotatedWithParams defaultCreator = this._originalInstantiator.getDefaultCreator();
        if (defaultCreator != null) {
            Method m;
            int mods;
            AnnotatedElement elem = defaultCreator.getAnnotated();
            if (elem instanceof Constructor) {
                Constructor ctor = (Constructor)elem;
                if (!Modifier.isPrivate(ctor.getModifiers())) {
                    return this.createSubclass(ctor, null).with(this._originalInstantiator);
                }
            } else if (elem instanceof Method && Modifier.isStatic(mods = (m = (Method)elem).getModifiers()) && !Modifier.isPrivate(mods)) {
                return this.createSubclass(null, m).with(this._originalInstantiator);
            }
        }
        return null;
    }

    protected OptimizedValueInstantiator createSubclass(Constructor<?> ctor, Method factory) {
        MyClassLoader loader = this._classLoader == null ? new MyClassLoader(this._valueClass.getClassLoader(), true) : this._classLoader;
        ClassName baseName = ClassName.constructFor(this._valueClass, "$Creator4JacksonDeserializer");
        byte[] bytecode = this.generateOptimized(baseName, ctor, factory);
        baseName.assignChecksum(bytecode);
        Class<?> impl = null;
        try {
            impl = loader.loadClass(baseName.getDottedName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (impl == null) {
            impl = loader.loadAndResolve(baseName, bytecode);
        }
        try {
            return (OptimizedValueInstantiator)((Object)impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + String.valueOf(baseName) + "': " + e.getMessage(), e);
        }
    }

    protected byte[] generateOptimized(ClassName baseName, Constructor<?> ctor, Method factory) {
        String tmpClassName = baseName.getSlashedTemplate();
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy(ClassFileVersion.JAVA_V5).with(TypeValidation.DISABLED).subclass(OptimizedValueInstantiator.class).name(tmpClassName).modifiers(new ModifierContributor.ForType[]{Visibility.PUBLIC, TypeManifestation.FINAL}).method((ElementMatcher)ElementMatchers.named((String)"with")).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new ByteCodeAppender.Simple(new StackManipulation[]{new ConstructorCallStackManipulation.OfInstrumentedType.OneArg(MethodVariableAccess.REFERENCE.loadFrom(1)), MethodReturn.REFERENCE})})).method((ElementMatcher)ElementMatchers.named((String)"createUsingDefault")).intercept((Implementation)new SimpleExceptionHandler(this.creatorInvokerStackManipulation(ctor, factory), this.creatorExceptionHandlerStackManipulation(), Exception.class, 1));
        return builder.make().getBytes();
    }

    private StackManipulation creatorInvokerStackManipulation(Constructor<?> ctor, Method factory) {
        ConstructorCallStackManipulation.KnownConstructorOfExistingType invokeManipulation = null == ctor ? MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(factory)) : new ConstructorCallStackManipulation.KnownConstructorOfExistingType(ctor);
        return new StackManipulation.Compound(new StackManipulation[]{invokeManipulation, MethodReturn.REFERENCE});
    }

    private StackManipulation creatorExceptionHandlerStackManipulation() {
        TypeDescription.ForLoadedType typeDescription = new TypeDescription.ForLoadedType(OptimizedValueInstantiator.class);
        MethodDescription.InDefinedShape methodDescription = (MethodDescription.InDefinedShape)((MethodList)typeDescription.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"_handleInstantiationProblem"))).getOnly();
        return new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.storeAt(2), MethodVariableAccess.REFERENCE.loadFrom(0), MethodVariableAccess.REFERENCE.loadFrom(1), MethodVariableAccess.REFERENCE.loadFrom(2), MethodInvocation.invoke((MethodDescription.InDefinedShape)methodDescription), MethodReturn.REFERENCE});
    }
}

