/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.comp;

import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.jr.ob.comp.ArrayComposer;
import tools.jackson.jr.ob.comp.ComposerBase;

public class ObjectComposer<PARENT extends ComposerBase>
extends ComposerBase {
    protected final PARENT _parent;
    protected final JsonGenerator _generator;

    public ObjectComposer(PARENT PARENT, JsonGenerator jsonGenerator) {
        this._parent = PARENT;
        this._generator = jsonGenerator;
    }

    @Override
    public void flush() {
        if (this._generator != null) {
            this._generator.close();
        }
    }

    @Override
    protected ObjectComposer<PARENT> _start() {
        this._generator.writeStartObject();
        return this;
    }

    @Override
    protected Object _finish() {
        if (this._open) {
            this._open = false;
            this._generator.writeEndObject();
        }
        return null;
    }

    public ArrayComposer<ObjectComposer<PARENT>> startArrayProperty(String string) {
        this._closeChild();
        this._generator.writeName(string);
        return this._startArray(this, this._generator);
    }

    public ArrayComposer<ObjectComposer<PARENT>> startArrayProperty(SerializableString serializableString) {
        this._closeChild();
        this._generator.writeName(serializableString);
        return this._startArray(this, this._generator);
    }

    public ObjectComposer<ObjectComposer<PARENT>> startObjectProperty(String string) {
        this._closeChild();
        this._generator.writeName(string);
        return this._startObject(this, this._generator);
    }

    public ObjectComposer<ObjectComposer<PARENT>> startObjectProperty(SerializableString serializableString) {
        this._closeChild();
        this._generator.writeName(serializableString);
        return this._startObject(this, this._generator);
    }

    public PARENT end() {
        this._closeChild();
        if (this._open) {
            this._open = false;
            this._generator.writeEndObject();
            ((ComposerBase)this._parent)._childClosed();
        }
        return this._parent;
    }

    public ObjectComposer<PARENT> put(String string, boolean bl) {
        this._generator.writeBooleanProperty(string, bl);
        return this;
    }

    public ObjectComposer<PARENT> putNull(String string) {
        this._generator.writeNullProperty(string);
        return this;
    }

    public ObjectComposer<PARENT> putObject(String string, Object object) {
        this._generator.writePOJOProperty(string, object);
        return this;
    }

    public ObjectComposer<PARENT> put(String string, int n) {
        this._generator.writeNumberProperty(string, n);
        return this;
    }

    public ObjectComposer<PARENT> put(String string, long l) {
        this._generator.writeNumberProperty(string, l);
        return this;
    }

    public ObjectComposer<PARENT> put(String string, double d) {
        this._generator.writeNumberProperty(string, d);
        return this;
    }

    public ObjectComposer<PARENT> put(String string, String string2) {
        this._generator.writeStringProperty(string, string2);
        return this;
    }

    public ObjectComposer<PARENT> put(String string, CharSequence charSequence) {
        String string2 = charSequence == null ? null : charSequence.toString();
        this._generator.writeStringProperty(string, string2);
        return this;
    }

    protected void _closeChild() {
        if (this._child != null) {
            this._child._finish();
            this._child = null;
        }
    }
}

