/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.ser;

import javax.xml.namespace.QName;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.dataformat.xml.ser.ToXmlGenerator;

public class XmlBeanPropertyWriter
extends BeanPropertyWriter {
    private static final long serialVersionUID = 1L;
    protected final QName _wrapperQName;
    protected final QName _wrappedQName;

    public XmlBeanPropertyWriter(BeanPropertyWriter wrapped, PropertyName wrapperName, PropertyName wrappedName) {
        this(wrapped, wrapperName, wrappedName, null);
    }

    public XmlBeanPropertyWriter(BeanPropertyWriter wrapped, PropertyName wrapperName, PropertyName wrappedName, ValueSerializer<Object> serializer) {
        super(wrapped);
        this._wrapperQName = this._qname(wrapperName);
        this._wrappedQName = this._qname(wrappedName);
        if (serializer != null) {
            this.assignSerializer(serializer);
        }
    }

    private QName _qname(PropertyName n) {
        String ns = n.getNamespace();
        if (ns == null) {
            ns = "";
        }
        return new QName(ns, n.getSimpleName());
    }

    public void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        ToXmlGenerator xmlGen;
        Class<?> cls;
        PropertySerializerMap map;
        Object value = this.get(bean);
        if (value == null) {
            return;
        }
        ValueSerializer ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, ctxt);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(ctxt, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean && this._handleSelfReference(bean, g, ctxt, ser)) {
            return;
        }
        ToXmlGenerator toXmlGenerator = xmlGen = g instanceof ToXmlGenerator ? (ToXmlGenerator)g : null;
        if (xmlGen != null) {
            xmlGen.startWrappedValue(this._wrapperQName, this._wrappedQName);
        }
        g.writeName((SerializableString)this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value, g, ctxt);
        } else {
            ser.serializeWithType(value, g, ctxt, this._typeSerializer);
        }
        if (xmlGen != null) {
            xmlGen.finishWrappedValue(this._wrapperQName, this._wrappedQName);
        }
    }
}

